/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsHyperLinkUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.src.common.srcbotp.SrcBotpUtils;
import kd.scm.src.common.util.SrcDemandUtils;
import kd.scm.src.common.util.SrcProjectUtil;
import org.apache.commons.collections.CollectionUtils;

public class SrcDemandItemEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener,
HyperLinkClickListener {
    private static final String BASE_DATA_ID = "BASE_DATA_ID";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "refresh": {
                this.getPageCache().remove(BASE_DATA_ID);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.setSumAmount();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            this.getModel().beginInit();
            this.setSceneDefaultValue();
            this.setScenePurlistTpl();
            this.getModel().endInit();
            this.getView().updateView("sourcetype2");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            OperateOption option = ((AbstractOperate)args.getSource()).getOption();
            option.setVariableValue("srcdemand_hassetdefaultval", "1");
        }
    }

    public void setSumAmount() {
        BigDecimal amount;
        DynamicObject obj = this.getModel().getDataEntity(true);
        String taxType = obj.getString("taxtype");
        DynamicObjectCollection cols = obj.getDynamicObjectCollection("entry");
        String amountPro = "";
        if (cols.size() == 0) {
            cols = obj.getDynamicObjectCollection("entryentity");
            if (Objects.equals(taxType, "1")) {
                amountPro = "taxamount";
            } else if (Objects.equals(taxType, "2")) {
                amountPro = "amount";
            }
        } else if (Objects.equals(taxType, "1")) {
            amountPro = "scenetaxamount";
        } else if (Objects.equals(taxType, "2")) {
            amountPro = "sceneamount";
        } else {
            return;
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject col : cols) {
            totalAmount = totalAmount.add(col.getBigDecimal(amountPro));
        }
        if (Objects.equals(taxType, "1")) {
            amount = obj.getBigDecimal("sumtaxamount");
            if (amount.compareTo(totalAmount) < 0) {
                obj.set("sumtaxamount", (Object)totalAmount);
                this.getView().updateView("sumtaxamount");
            }
        } else if (Objects.equals(taxType, "2") && (amount = obj.getBigDecimal("sumamount")).compareTo(totalAmount) < 0) {
            obj.set("sumamount", (Object)totalAmount);
            this.getView().updateView("sumamount");
        }
    }

    public void setSceneDefaultValue() {
        if (this.getModel().getDataEntity().getBoolean("ismultiscene")) {
            return;
        }
        this.getModel().setValue("sourcetype2", (Object)this.getModel().getDataEntity().getDynamicObject("srctype2.sourcetype"));
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entry");
        rows.removeAll((Collection)rows);
        DynamicObject row = rows.addNew();
        DynamicObject obj = this.getModel().getDataEntity();
        row.set("scenename_des1", obj.get("title"));
        row.set("purtype", (Object)obj.getDynamicObject("srctype2.sourcetype"));
        row.set("srcflowconfig", (Object)obj.getDynamicObject("srctype2"));
        this.setSceneSuppliers(row);
        row.set("scenestatus", (Object)"A");
        row.set("scenetaxamount", obj.get("sumtaxamount"));
        row.set("sceneamount", obj.get("sumamount"));
        MultiBasedataUtils.setMultiBasedataForEntryRow((DynamicObject)row, this.getPurlistId(), (String)"decisionitem");
        MultiBasedataUtils.setMultiBasedataForEntryRow((DynamicObject)row, this.getCategoryId(), (String)"category");
    }

    private void setSceneSuppliers(DynamicObject row) {
        Set supplierIds = null;
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entrysupplier");
        if (rows.size() > 0) {
            supplierIds = rows.stream().filter(e -> e.getLong("supplier.id") > 0L).map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        }
        if (null == supplierIds || supplierIds.size() == 0) {
            supplierIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)this.getModel().getDataEntity(), (String)"supplierscope");
        }
        if (null != supplierIds && supplierIds.size() > 0) {
            MultiBasedataUtils.setMultiBasedataForEntryRow((DynamicObject)row, supplierIds, (String)"suppliers");
        }
    }

    private Set<Long> getPurlistId() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> getCategoryId() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        return rows.stream().map(e -> e.getLong("category2.id")).collect(Collectors.toSet());
    }

    public void setScenePurlistTpl() {
        if (!this.getModel().getDataEntity().getBoolean("sceneitem")) {
            return;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entry");
        int i = 0;
        for (DynamicObject row : rows) {
            long defaultTplId = SrcBotpUtils.getDefaultPurlistTplId((DynamicObject)row.getDynamicObject("purtype"));
            this.getModel().setValue("purlisttpl", (Object)new Object[]{defaultTplId}, i);
            ++i;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean sceneItem = this.getModel().getDataEntity().getBoolean("sceneitem");
        BasedataEdit itemEdit = (BasedataEdit)this.getControl("decisionitem");
        if (Objects.nonNull(itemEdit)) {
            itemEdit.setMustInput(sceneItem);
        }
        SrcProjectUtil.setBizTypeDefaultValue((IDataModel)this.getModel());
        this.setMaterialEnable();
        this.setSourceFlowMustInput();
        this.getModel().setDataChanged(false);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryKey = e.getEntryProp().getName();
        if (!"entryentity".equals(entryKey)) {
            return;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (rows.size() == 0) {
            return;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entry");
        if (this.getModel().getDataEntity().getBoolean("sceneitem")) {
            this.setMultiBaseDataItem(entries, this.getDeleteItemIdSet(rows, e.getRowIndexs()));
        } else {
            this.setMultiBaseDataCategory(entries, SrcDemandUtils.getDeleteCategoryIdSet((DynamicObjectCollection)rows, (int[])e.getRowIndexs()));
        }
    }

    private void calcTotalAmount(DynamicObjectCollection rows, IDataModel model, int[] rowIndexs) {
        int i = 0;
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject row : rows) {
            boolean isDelete = false;
            for (int rowIndex : rowIndexs) {
                if (i != rowIndex) continue;
                isDelete = true;
                break;
            }
            if (!isDelete) {
                sumTaxAmount = sumTaxAmount.add(row.getBigDecimal("taxamount"));
                sumAmount = sumAmount.add(row.getBigDecimal("amount"));
            }
            ++i;
        }
        model.setValue("sumtaxamount", (Object)sumTaxAmount);
        model.setValue("sumamount", (Object)sumAmount);
    }

    private Set<Object> getDeleteItemIdSet(DynamicObjectCollection rows, int[] indexes) {
        HashSet<Object> itemSet = new HashSet<Object>(16);
        for (int index : indexes) {
            PdsCommonUtils.setPageCache((IPageCache)this.getPageCache(), (String)BASE_DATA_ID, (Object)String.valueOf(((DynamicObject)rows.get(index)).getPkValue()));
        }
        itemSet.addAll(PdsCommonUtils.getPageCache((IPageCache)this.getPageCache(), (String)BASE_DATA_ID));
        return itemSet;
    }

    private void setMultiBaseDataCategory(DynamicObjectCollection entries, Set<Object> itemSet) {
        int i = 0;
        for (DynamicObject entry : entries) {
            DynamicObjectCollection categories = entry.getDynamicObjectCollection("category");
            DynamicObjectCollection cols = new DynamicObjectCollection(categories.getDynamicObjectType(), (Object)categories);
            for (DynamicObject category : categories) {
                DynamicObject obj = category.getDynamicObject("fbasedataid");
                if (itemSet.contains(obj.getPkValue())) continue;
                cols.add((Object)category);
            }
            this.getModel().setValue("category", (Object)cols, i);
            this.getView().updateView("category", i);
            ++i;
        }
    }

    private void setMultiBaseDataItem(DynamicObjectCollection entries, Set<Object> itemSet) {
        int i = 0;
        for (DynamicObject entry : entries) {
            DynamicObjectCollection items = entry.getDynamicObjectCollection("decisionitem");
            DynamicObjectCollection cols = new DynamicObjectCollection(items.getDynamicObjectType(), (Object)items);
            for (DynamicObject item : items) {
                DynamicObject obj = item.getDynamicObject("fbasedataid");
                if (null == obj || itemSet.contains(obj.getPkValue())) continue;
                cols.add((Object)item);
            }
            this.getModel().setValue("decisionitem", (Object)cols, i);
            this.getView().updateView("decisionitem", i);
            ++i;
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit srcType2;
        BasedataEdit sourcetype2;
        BasedataEdit purType;
        BasedataEdit material;
        BasedataEdit category;
        super.registerListener(e);
        BasedataEdit decisionItem = (BasedataEdit)this.getControl("decisionitem");
        if (Objects.nonNull(decisionItem)) {
            decisionItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            decisionItem.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if (Objects.nonNull(category = (BasedataEdit)this.getControl("category"))) {
            category.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(material = (BasedataEdit)this.getControl("material1"))) {
            material.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if (Objects.nonNull(purType = (BasedataEdit)this.getControl("purtype"))) {
            purType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(sourcetype2 = (BasedataEdit)this.getControl("sourcetype2"))) {
            sourcetype2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(srcType2 = (BasedataEdit)this.getControl("srctype2"))) {
            srcType2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
        switch (key) {
            case "decisionitem": {
                long pkVal = this.getModel().getDataEntity().getLong("id");
                if (0L == pkVal) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff0c\u5426\u5219\u65e0\u6cd5\u9009\u62e9\u5230\u6807\u7684\u3002", (String)"SrcDemandItemEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Object scneObj = this.getModel().getValue("scenename_des1", evt.getRow());
                if (scneObj == null || "".equals(scneObj.toString().trim())) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199%1$s\u3002", (String)"SrcDemandItemEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]), PdsMetadataUtil.getFieldDisplayName((Control)this.getControl("scenename_des1"))));
                    evt.setCancel(true);
                    break;
                }
                showParameter.getListFilterParameter().setFilter(this.setDecisionItemFilter(evt.getRow()));
                break;
            }
            case "category": {
                showParameter.getListFilterParameter().setFilter(SrcDemandUtils.getCategoryFilter((DynamicObjectCollection)this.getModel().getEntryEntity("entryentity")));
                break;
            }
            case "sourcetype2": 
            case "purtype": {
                evt.getFormShowParameter().setCaption(evt.getProperty().getDisplayName().getLocaleValue());
                String isSell = this.getModel().getDataEntity().getString("isselloff");
                if (Objects.equals("A", isSell)) {
                    showParameter.getListFilterParameter().setFilter(new QFilter("isselloff", "=", (Object)true));
                    break;
                }
                if (!Objects.equals("B", isSell)) break;
                showParameter.getListFilterParameter().setFilter(new QFilter("isselloff", "=", (Object)false));
                break;
            }
            case "srctype2": {
                this.setSrctypeSelect(evt);
                break;
            }
        }
    }

    private QFilter setDecisionItemFilter(int index) {
        long sourceId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity());
        QFilter qFilter = new QFilter("source.id", "=", (Object)sourceId);
        DynamicObjectCollection sceneEntries = this.getModel().getEntryEntity("entry");
        HashSet ids = new HashSet(32);
        for (int i = 0; i < sceneEntries.size(); ++i) {
            DynamicObjectCollection items;
            if (i == index || CollectionUtils.isEmpty((Collection)(items = ((DynamicObject)sceneEntries.get(i)).getDynamicObjectCollection("decisionitem")))) continue;
            Set itemIds = items.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toSet());
            ids.addAll(itemIds);
        }
        ids.addAll(PdsCommonUtils.getPageCache((IPageCache)this.getPageCache(), (String)BASE_DATA_ID));
        qFilter.and(new QFilter("id", "not in", ids));
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "sceneitem": {
                BasedataEdit decisionItem = (BasedataEdit)this.getControl("decisionitem");
                if (Objects.isNull(decisionItem)) break;
                DynamicObjectCollection entries = this.getModel().getEntryEntity("entry");
                if (((Boolean)newValue).booleanValue()) {
                    for (int i = 0; i < entries.size(); ++i) {
                        this.getModel().setValue("category", null, i);
                    }
                    decisionItem.setMustInput(true);
                } else {
                    for (int i = 0; i < entries.size(); ++i) {
                        this.getModel().setValue("decisionitem", null, i);
                    }
                    decisionItem.setMustInput(false);
                }
                this.setMaterialEnable();
                break;
            }
            case "decisionitem": {
                if (Objects.isNull(newValue)) {
                    this.getModel().setValue("category", null, rowIndex);
                    this.getModel().setValue("sceneamount", null, rowIndex);
                    this.getModel().setValue("scenetaxamount", null, rowIndex);
                    break;
                }
                this.getModel().setValue("category", (Object)SrcDemandUtils.getCategoryIds((DynamicObjectCollection)((DynamicObjectCollection)newValue)), rowIndex);
                this.getModel().setValue("sceneamount", (Object)SrcDemandUtils.sumSceneAmount((DynamicObjectCollection)((DynamicObjectCollection)newValue), (String)"amount"), rowIndex);
                this.getModel().setValue("scenetaxamount", (Object)SrcDemandUtils.sumSceneAmount((DynamicObjectCollection)((DynamicObjectCollection)newValue), (String)"taxamount"), rowIndex);
                break;
            }
            case "material1": 
            case "category2": {
                if (this.getModel().getDataEntity().getBoolean("sceneitem")) break;
                this.clearEntryPropertyValue("entry", "category");
                break;
            }
            case "materialname": 
            case "taxamount": 
            case "amount": {
                this.saveAndRemoveCache();
                this.calcSceneAmount();
                break;
            }
            case "isselloff": {
                this.getModel().deleteEntryData("entry");
                break;
            }
            case "unit2": {
                if (Objects.isNull(newValue)) break;
                PdsCommonUtils.setScaleByUnit((IDataModel)this.getModel(), (DynamicObject)((DynamicObject)newValue), (BigDecimal)((BigDecimal)this.getModel().getValue("qty", rowIndex)), (String)"qty", (int)rowIndex);
                PdsCommonUtils.setScaleByUnit((IDataModel)this.getModel(), (DynamicObject)((DynamicObject)newValue), (BigDecimal)((BigDecimal)this.getModel().getValue("reqqty2", rowIndex)), (String)"reqqty2", (int)rowIndex);
                break;
            }
            case "ismultiscene": {
                this.setSourceFlowMustInput();
                if (this.getModel().getDataEntity().getBoolean("ismultiscene")) break;
                this.getView().getModel().deleteEntryData("entry");
                break;
            }
        }
    }

    private void clearEntryPropertyValue(String entryNumber, String property) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryNumber);
        for (int i = 0; i < rows.size(); ++i) {
            this.getModel().setValue(property, null, i);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = ((FieldEdit)afterF7SelectEvent.getSource()).getFieldKey()) {
            case "decisionitem": {
                this.setMaterialEnable();
                break;
            }
            case "material1": {
                this.saveAndRemoveCache();
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String fieldName = e.getEntryProp().getName();
        if ("entry".equals(fieldName)) {
            this.setMaterialEnable();
        }
        if ("entryentity".equals(fieldName)) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
            if (rows.size() == 0) {
                return;
            }
            this.calcTotalAmount(rows, this.getModel(), e.getRowIndexs());
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String fieldName = e.getEntryProp().getName();
        if (!"entry".equals(fieldName)) {
            return;
        }
        Object title = this.getModel().getValue("title");
        if (Objects.nonNull(title)) {
            RowDataEntity[] rows = e.getRowDataEntities();
            this.getModel().setValue("scenename_des1", title, rows[0].getRowIndex());
        }
    }

    private void saveAndRemoveCache() {
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"src_demandf7two").getDynamicObjectType());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
    }

    private void calcSceneAmount() {
        DynamicObjectCollection cols = this.getModel().getEntryEntity("entry");
        HashSet ids = new HashSet(16);
        for (DynamicObject col : cols) {
            DynamicObjectCollection items = col.getDynamicObjectCollection("decisionitem");
            if (!CollectionUtils.isNotEmpty((Collection)items)) continue;
            ids.addAll(items.stream().map(material -> material.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(PdsCommonUtils::object2Long).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            QFilter qFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection materialObjs = QueryServiceHelper.query((String)"src_demandf7two", (String)"id,amount,taxamount", (QFilter[])qFilter.toArray());
            Map<Long, DynamicObject> materialMap = materialObjs.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
            for (int i = 0; i < cols.size(); ++i) {
                this.getModel().setValue("sceneamount", (Object)SrcDemandUtils.sumSceneAmountByDb((DynamicObject)((DynamicObject)cols.get(i)), (String)"amount", materialMap), i);
                this.getModel().setValue("scenetaxamount", (Object)SrcDemandUtils.sumSceneAmountByDb((DynamicObject)((DynamicObject)cols.get(i)), (String)"taxamount", materialMap), i);
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        PdsHyperLinkUtils.editOpenFormByEntryBillNo((IFormView)this.getView(), (HyperLinkClickEvent)args, (String)"projectno", (String)"src_project");
    }

    private void setMaterialEnable() {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("entry");
        HashSet itemIds = new HashSet(16);
        for (DynamicObject entryRow : entryRows) {
            Set bdSet = entryRow.getDynamicObjectCollection("decisionitem").stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toSet());
            itemIds.addAll(bdSet);
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < rows.size(); ++i) {
            if (itemIds.contains(((DynamicObject)rows.get(i)).getPkValue())) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"material1"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"material1"});
        }
    }

    private void setSrctypeSelect(BeforeF7SelectEvent evt) {
        QFilter qfilter = null;
        String isSell = this.getModel().getDataEntity().getString("isselloff");
        qfilter = Objects.equals("A", isSell) ? new QFilter("sourcetype.isselloff", "=", (Object)true) : new QFilter("sourcetype.isselloff", "=", (Object)false);
        DynamicObject sourcetype = this.getModel().getDataEntity().getDynamicObject("sourcetype2");
        if (sourcetype != null) {
            qfilter.and("sourcetype", "=", sourcetype.getPkValue());
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qfilter);
    }

    private void setSourceFlowMustInput() {
        if (!this.getModel().getDataEntity().getBoolean("ismultiscene")) {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"srctype2", (boolean)true);
        } else {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"srctype2", (boolean)false);
        }
    }
}

