/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.supplierfilter.SupplierFilterUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class SrcDemandSupplierEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private boolean isPuragentChange = false;

    public void registerListener(EventObject e) {
        BasedataEdit suppliersEdit;
        BasedataEdit scopeEdit;
        BasedataEdit supplierUserEdit;
        super.registerListener(e);
        BasedataEdit supplierEdit = (BasedataEdit)this.getView().getControl("supplier");
        if (null != supplierEdit) {
            supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (supplierUserEdit = (BasedataEdit)this.getView().getControl("supplieruser"))) {
            supplierUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (scopeEdit = (BasedataEdit)this.getView().getControl("supplierscope"))) {
            scopeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (suppliersEdit = (BasedataEdit)this.getView().getControl("suppliers"))) {
            suppliersEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String property = evt.getProperty().getName();
        int currIndex = evt.getChangeSet()[0].getRowIndex();
        switch (property) {
            case "supplier": {
                SupplierUtil.supplierChangedHandle((IDataModel)this.getModel(), (PropertyChangedArgs)evt);
                this.resetPurAgentValues(currIndex, "ispuragent", "isfeeagent", "ispuraptitude");
                break;
            }
            case "ispuragent": {
                this.resetPurAgentValues(currIndex, "ispuragent", null, null);
                break;
            }
            case "isfeeagent": {
                this.resetPurAgentValues(currIndex, null, "isfeeagent", null);
                break;
            }
            case "ispuraptitude": {
                this.resetPurAgentValues(currIndex, null, null, "ispuraptitude");
                break;
            }
            case "supplieruser": {
                Map linkManMap;
                Object newValue = evt.getChangeSet()[0].getNewValue();
                if (Objects.isNull(newValue) || null == (linkManMap = PdsLinkManFacade.getLinkManBySupplierUser((DynamicObjectCollection)((DynamicObjectCollection)newValue))) || linkManMap.size() <= 0) break;
                this.getModel().setValue("linkman", linkManMap.get("linkman"), currIndex);
                this.getModel().setValue("phone", linkManMap.get("phone"), currIndex);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = null;
        switch (key) {
            case "supplier": 
            case "suppliers": 
            case "supplierscope": {
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                String supplierType = SupplierFilterUtils.inviteSupplierType();
                if (null == supplierType) break;
                HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(1);
                paramMap.put("ismustinput", true);
                SupplierFilterUtils.setSupplierF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity(true), (String)(this.getView().getEntityId() + '_' + supplierType + '_' + "filter"), paramMap);
                break;
            }
            case "supplieruser": {
                Object currSupObj = this.getModel().getValue("supplier", evt.getRow());
                if (null == currSupObj) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SrcDemandSupplierEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)((DynamicObject)currSupObj).getLong("id"));
                qFilter = new QFilter("bizpartner", "=", (Object)bizPartnerId);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    private void resetPurAgentValues(int currIndex, String isPurAgentField, String isFeeAgentField, String isPurAptitudeField) {
        if (!this.isPuragentChange) {
            this.isPuragentChange = true;
            SupplierUtil.isPuragentChangedHandle((IFormView)this.getView(), (int)currIndex, (String)isPurAgentField, (String)isFeeAgentField, (String)isPurAptitudeField);
            this.isPuragentChange = false;
        }
    }
}

