/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.formplugin.edit.PdsChgCompReloadDataTpl;

public class SrcFeeConfigChgEdit
extends PdsChgCompReloadDataTpl {
    protected void reloadBillData() {
        this.setFeeConfig();
    }

    protected void reloadEntryData() {
        this.createEntryEntity();
    }

    private void createEntryEntity() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return;
        }
        DynamicObject feeCfgObj = BusinessDataServiceHelper.loadSingle((Object)projectObj.getLong("id"), (String)"src_paymanage_cfg");
        if (null == feeCfgObj) {
            return;
        }
        DynamicObjectCollection entryentity = feeCfgObj.getDynamicObjectCollection("entrypackage");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entrypackage");
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (DynamicObject entry : entryentity) {
            ts.set("package", entry.get("package.id"), i);
            ts.set("packfeeitem", entry.get("packfeeitem.id"), i);
            ts.set("packfeeamount", entry.get("packfeeamount"), i);
            ts.set("packdocamount", entry.get("packdocamount"), i);
            ts.set("seq", (Object)(i + 1), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entrypackage", ts);
    }

    private void setFeeConfig() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject feeCfgObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity().getDynamicObject("project")), (String)"src_paymanage_cfg");
        if (null != feeCfgObj) {
            model.setValue("feeway", (Object)feeCfgObj.getLong("feeway.id"));
            model.setValue("feeitem", (Object)feeCfgObj.getLong("feeitem.id"));
            model.setValue("currency", (Object)feeCfgObj.getLong("currency.id"));
            model.setValue("feeamount", feeCfgObj.get("feeamount"));
            model.setValue("docamount", feeCfgObj.get("docamount"));
            model.setValue("remark", (Object)this.getMessage(feeCfgObj));
        }
    }

    private String getMessage(DynamicObject feeCfgObj) {
        StringBuilder message = new StringBuilder();
        message.append(String.format(ResManager.loadKDString((String)"\u6536\u8d39\u65b9\u5f0f\uff1a%s", (String)"SrcFeeConfigChgEdit_14", (String)"scm-src-formplugin", (Object[])new Object[0]), feeCfgObj.getString("feeway.name")));
        if (!"C020701".equals(feeCfgObj.getString("feeway.number"))) {
            message.append("\uff0c");
            message.append(ResManager.loadKDString((String)"\u6536\u8d39\u9879\uff1a", (String)"SrcFeeConfigChgEdit_9", (String)"scm-src-formplugin", (Object[])new Object[0]));
            message.append(feeCfgObj.getString("feeitem.name"));
            message.append("\uff0c");
            message.append(String.format(ResManager.loadKDString((String)"\u5e01\u522b\uff1a%s", (String)"SrcFeeConfigChgEdit_15", (String)"scm-src-formplugin", (Object[])new Object[0]), feeCfgObj.getString("currency.name")));
            if ("C020702".equals(feeCfgObj.getString("feeway.number"))) {
                if ("775220440363722752".equals(feeCfgObj.getString("feeitem.id")) || "775220031326809088".equals(feeCfgObj.getString("feeitem.id"))) {
                    message.append("\uff0c");
                    message.append(String.format(ResManager.loadKDString((String)"\u6295\u6807\u4fdd\u8bc1\u91d1\uff1a%s", (String)"SrcFeeConfigChgEdit_16", (String)"scm-src-formplugin", (Object[])new Object[0]), feeCfgObj.getBigDecimal("feeamount").setScale(2)));
                }
                if ("775220440363722752".equals(feeCfgObj.getString("feeitem.id")) || "775219867547625472".equals(feeCfgObj.getString("feeitem.id"))) {
                    message.append("\uff0c");
                    message.append(String.format(ResManager.loadKDString((String)"\u6807\u4e66\u8d39\uff1a%s", (String)"SrcFeeConfigChgEdit_17", (String)"scm-src-formplugin", (Object[])new Object[0]), feeCfgObj.getBigDecimal("docamount").setScale(2)));
                }
            } else {
                message.append("\uff0c");
                message.append(ResManager.loadKDString((String)"\u6309\u6807\u6bb5\u6536\u8d39(\u6536\u8d39\u660e\u7ec6\u7701\u7565)", (String)"SrcFeeConfigChgEdit_13", (String)"scm-src-formplugin", (Object[])new Object[0]));
            }
        }
        return message.toString();
    }
}

