/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import com.alibaba.druid.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.supplierfilter.SupplierFilterUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.src.common.srcbotp.SrcProjectBotpSupplier;
import kd.scm.src.common.util.SrcAptitudeUtils;
import kd.scm.src.common.util.SrcSaveDate2CacheUtil;

public class SrcInviteSupplierAssEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(SrcInviteSupplierAssEdit.class);
    private boolean isPuragentChange = false;

    public void registerListener(EventObject e) {
        BasedataEdit purlistEdit;
        BasedataEdit supplierUserEdit;
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("supplier");
        if (null != basedataEdit) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (supplierUserEdit = (BasedataEdit)this.getView().getControl("supplieruser"))) {
            supplierUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (purlistEdit = (BasedataEdit)this.getView().getControl("purlists"))) {
            purlistEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String property = evt.getProperty().getName();
        int currIndex = evt.getChangeSet()[0].getRowIndex();
        switch (property) {
            case "supplier": {
                SupplierUtil.supplierChangedHandle((IDataModel)this.getModel(), (PropertyChangedArgs)evt);
                this.resetPurAgentValues(currIndex, "ispuragent", "isfeeagent", "ispuraptitude");
                break;
            }
            case "ispuragent": {
                this.resetPurAgentValues(currIndex, "ispuragent", null, null);
                break;
            }
            case "isfeeagent": {
                this.resetPurAgentValues(currIndex, null, "isfeeagent", null);
                break;
            }
            case "ispuraptitude": {
                this.resetPurAgentValues(currIndex, null, null, "ispuraptitude");
                break;
            }
            case "supplieruser": {
                List userList;
                DynamicObject userObj;
                Object newValue = evt.getChangeSet()[0].getNewValue();
                if (Objects.isNull(newValue) || !Objects.nonNull(userObj = SupplierUtil.getQualifiedSupplierUser(userList = ((DynamicObjectCollection)newValue).stream().map(col -> col.getDynamicObject("fbasedataid")).distinct().collect(Collectors.toList())))) break;
                long userId = userObj.getLong("user.id");
                DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_user", (String)"id,name,phone", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
                this.getModel().setValue("linkman", (Object)obj.getString("name"), currIndex);
                this.getModel().setValue("phone", (Object)obj.getString("phone"), currIndex);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        boolean isdecision = (Boolean)parentView.getModel().getValue("purdecision");
        this.getModel().setValue("purdecision", (Object)isdecision);
        SrcSaveDate2CacheUtil.saveDate2Cache((IFormView)this.getView(), (String)"src_supplier_invite", (String)"src_invitesupplier");
        this.setRiskinfoVisiable();
        FieldEdit manageType = (FieldEdit)this.getControl("managetype");
        manageType.setFieldKey(null);
        this.loadSupplierFromDemand();
    }

    private void loadSupplierFromDemand() {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(this.getView());
        ExtPluginFactory.executeExtplugin((String)SrcProjectBotpSupplier.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcProjectBotpSupplier.class.getName());
    }

    private void setRiskinfoVisiable() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String EntityId = parentView.getEntityId();
        if (StringUtils.equals((String)EntityId, (String)"src_bidpublish")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"riskinfo"});
        }
    }

    private List<String> getPackageName() {
        ArrayList<String> packagelist = new ArrayList();
        String parentId = this.getModel().getDataEntity().getString("parentid");
        QFilter qFilter = new QFilter("project.id", "=", (Object)Long.parseLong(parentId.toString()));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_packagef7", (String)"id,packagename", (QFilter[])new QFilter[]{qFilter});
        packagelist = rows.stream().map(row -> row.getString("packagename")).distinct().collect(Collectors.toList());
        return packagelist;
    }

    private void batchinvite(Boolean isinvite) {
        int i;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entrysupplier");
        int[] selectedIds = grid.getSelectRows();
        if (selectedIds == null || selectedIds.length < 2) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e24\u6761\u5206\u5f55\u3002", (String)"SrcInviteSupplierAssEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        String note = "";
        for (i = 0; i < selectedIds.length && StringUtils.isEmpty((String)(note = this.getView().getModel().getEntryRowEntity("entrysupplier", selectedIds[i]).getString("note"))); ++i) {
        }
        for (i = 0; i < selectedIds.length; ++i) {
            this.getModel().setValue("isinvite", (Object)isinvite, selectedIds[i]);
            if (note.equals(ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u63a8\u8350\u5165\u56f4", (String)"SrcInviteSupplierAssEdit_11", (String)"scm-src-formplugin", (Object[])new Object[0]))) continue;
            this.getModel().setValue("note", (Object)note, selectedIds[i]);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        switch (operateKey) {
            case "batchinvite": {
                this.batchinvite(Boolean.TRUE);
                break;
            }
            case "batchnotinvite": {
                this.batchinvite(Boolean.FALSE);
                break;
            }
            case "export": {
                this.exportTpl();
                break;
            }
            case "save": 
            case "submit": {
                this.deleteInvalidRows(this.getModel().getDataEntity(true));
                break;
            }
        }
    }

    protected void exportTpl() {
        IFormView view = this.getView();
        try {
            ExcelDataEntity excelDataEntity = new ExcelDataEntity();
            excelDataEntity.createSheet();
            String entityKey = this.getModel().getDataEntityType().getName();
            String fileName = ResManager.loadKDString((String)"\u9080\u8bf7\u4f9b\u5e94\u5546\u540d\u5355", (String)"SrcInviteSupplierAssEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0]);
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityKey);
            if (entityKey != null || null != type) {
                fileName = type.getDisplayName().toString() + DateUtil.date2str((Date)new Date(), (String)"yyyyMMddHHmmss");
            }
            excelDataEntity.setFileName(ResManager.loadKDString((String)(fileName + ".xlsx"), (String)"SrcInviteSupplierAssEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
            excelDataEntity.setEntityKey(entityKey);
            excelDataEntity.setEntryKey("entrysupplier");
            ExcelUtil.setExcelHeader((ExcelDataEntity)excelDataEntity, (IDataModel)this.getModel());
            this.setEexclBody(excelDataEntity);
            ExcelUtil.exportExcel((IFormView)view, (ExcelDataEntity)excelDataEntity);
        }
        catch (IOException e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"SrcInviteSupplierAssEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }

    private void setEexclBody(ExcelDataEntity excelDataEntity) throws IOException {
        int rowCount = this.getModel().getEntryRowCount("entrysupplier");
        List columnKeyList = excelDataEntity.getColumnKeyList();
        for (int i = 0; i < rowCount; ++i) {
            List<String> rowData = this.getRowDataByIndex(columnKeyList, i);
            excelDataEntity.createRow(0, i + 1);
            excelDataEntity.setRowValue(0, rowData, i + 1);
        }
    }

    private List<String> getRowDataByIndex(List<String> columnKeyList, int i) {
        ArrayList<String> rowData = new ArrayList<String>(columnKeyList.size());
        DynamicObject dyObj = this.getModel().getEntryRowEntity("entrysupplier", i);
        for (String column : columnKeyList) {
            Object columnVal = dyObj.get(column);
            Object val = "";
            if (columnVal == null) {
                if ("package".equals(column)) {
                    IFormView parentView = this.getView().getParentView();
                    if (parentView == null) {
                        return null;
                    }
                    String managetype = parentView.getModel().getDataEntity().getString("managetype");
                    if ("1".equals(managetype) || "3".equals(managetype)) {
                        List<String> packageNameList = this.getPackageName();
                        for (int j = 0; j < packageNameList.size(); ++j) {
                            val = val + packageNameList.get(j) + "  ";
                        }
                    }
                } else {
                    val = "";
                }
            } else if (null != columnVal && columnVal instanceof DynamicObject) {
                if ("supplier".equals(column)) {
                    val = ((DynamicObject)columnVal).get("number");
                }
                if ("package".equals(column)) {
                    val = ((DynamicObject)columnVal).get("packagename");
                }
            } else {
                val = columnVal instanceof BigDecimal ? (((BigDecimal)columnVal).compareTo(BigDecimal.ZERO) == 0 ? "" : columnVal) : (columnVal instanceof Boolean ? (((Boolean)columnVal).booleanValue() ? ResManager.loadKDString((String)"\u662f", (String)"SrcInviteSupplierAssEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SrcInviteSupplierAssEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0])) : ("source".equals(column) ? ("1".equals(columnVal) ? ResManager.loadKDString((String)"\u6765\u6e90\u91c7\u59d4\u4f1a", (String)"SrcInviteSupplierAssEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7acb\u9879\u65b0\u589e", (String)"SrcInviteSupplierAssEdit_8", (String)"scm-src-formplugin", (Object[])new Object[0])) : columnVal));
            }
            rowData.add(String.valueOf(val));
        }
        return rowData;
    }

    private List<Object> getSupListByScene() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        DynamicObject sceneobj = parentView.getModel().getDataEntity().getDynamicObject("scene");
        if (sceneobj == null) {
            return null;
        }
        ArrayList<Object> suplist = new ArrayList();
        DynamicObjectCollection rows = sceneobj.getDynamicObjectCollection("entrysupplier");
        if (rows == null || rows.size() == 0) {
            return null;
        }
        suplist = rows.stream().filter(row -> row.getDynamicObject("supplier") != null).map(row -> row.getLong("supplier.id")).distinct().collect(Collectors.toList());
        logger.info("\u4ece\u5bfb\u6e90\u573a\u666f\u4e2d\u62ff\u5230\u7684\u4f9b\u5e94\u5546Id\uff1a" + suplist);
        return suplist;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = null;
        switch (key) {
            case "supplier": {
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                List<Object> suplist = this.getSupListByScene();
                if (suplist != null && suplist.size() > 0) {
                    qFilter = new QFilter("id", "in", suplist);
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                String supplierType = SupplierFilterUtils.inviteSupplierType();
                if (null == supplierType) break;
                HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(1);
                paramMap.put("ismustinput", true);
                SupplierFilterUtils.setSupplierF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity().getDynamicObject("projectf7"), (String)("src_project_" + supplierType + '_' + "filter"), paramMap);
                break;
            }
            case "supplieruser": {
                Object currSupObj = this.getModel().getValue("supplier", evt.getRow());
                if (null == currSupObj) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SrcInviteSupplierAssEdit_10", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)((DynamicObject)currSupObj).getLong("id"));
                qFilter = new QFilter("bizpartner", "=", (Object)bizPartnerId);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "purlists": {
                Object supplierObj;
                QFilter purlistFilter = new QFilter("project", "=", (Object)this.getModel().getDataEntity().getLong("projectf7.id"));
                purlistFilter.and("billtype", "=", (Object)"1");
                if ("2".equals(this.getModel().getDataEntity().getString("projectf7.managetype"))) {
                    Object packageObj = this.getModel().getValue("package", evt.getRow());
                    if (null == packageObj) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6807\u6bb5\u3002", (String)"SrcInviteSupplierAssEdit_12", (String)"scm-src-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    purlistFilter.and("package", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)packageObj)));
                }
                if (null == (supplierObj = this.getModel().getValue("supplier", evt.getRow()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"SrcInviteSupplierAssEdit_10", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (!QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])purlistFilter.toArray())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6807\u7684\uff0c\u8bf7\u5148\u586b\u5199\u901a\u7528\u62a5\u4ef7\u5355\u5e76\u4fdd\u5b58\u5355\u636e\uff0c\u518d\u8fdb\u884c\u9009\u62e9\u3002", (String)"SrcInviteSupplierAssEdit_13", (String)"scm-src-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Set purlistIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)this.getModel().getEntryRowEntity("entrysupplier", evt.getRow()), (String)"purlistscope");
                if (null != purlistIds && purlistIds.size() > 0) {
                    purlistFilter = purlistFilter.and("id", "in", (Object)purlistIds);
                }
                showParameter.getListFilterParameter().setFilter(purlistFilter);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (!PdsCommonUtils.isValidBillType((IFormView)parentView)) {
            return;
        }
        String entityId = parentView.getEntityId();
        boolean isEnable = true;
        boolean isSourceSupplier = false;
        if (!"src_bidpublish".equals(entityId) && "src_project".equals(entityId) && (isSourceSupplier = parentView.getModel().getDataEntity().getBoolean("issourcesupplier"))) {
            isEnable = false;
        }
        if (!isEnable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
            if (isSourceSupplier) {
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"package", "supplier", "note", "isconfirm"});
            } else {
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{"package", "supplier", "isinvite", "note", "isconfirm"});
            }
        }
        if ("src_invitesupplier".equals(entityId)) {
            Boolean isMultiPackage = (Boolean)this.getModel().getValue("ismultipackage");
            if (isMultiPackage.booleanValue()) {
                Boolean isByPackage = (Boolean)parentView.getModel().getValue("isbypackage");
                if (isByPackage.booleanValue()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"package"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"package"});
            }
        }
        if (!SrcAptitudeUtils.isSupplierReplyAptitude((DynamicObject)parentView.getModel().getDataEntity())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ispuraptitude"});
        }
    }

    private void deleteInvalidRows(DynamicObject billObj) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entrysupplier");
        if (rows == null || rows.size() == 0) {
            return;
        }
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject obj = (DynamicObject)ite.next();
            if (obj.getDynamicObject("supplier") != null && obj.getLong("supplier.id") != 0L) continue;
            ite.remove();
        }
        this.getView().updateView();
    }

    private void resetPurAgentValues(int currIndex, String isPurAgentField, String isFeeAgentField, String isPurAptitudeField) {
        if (!this.isPuragentChange) {
            this.isPuragentChange = true;
            SupplierUtil.isPuragentChangedHandle((IFormView)this.getView(), (int)currIndex, (String)isPurAgentField, (String)isFeeAgentField, (String)isPurAptitudeField);
            this.isPuragentChange = false;
        }
    }
}

