/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcProjectSchemeHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.setProjectScheme(context);
    }

    private void setProjectScheme(ExtPluginContext context) {
        DynamicObject stdSchemeObj = this.getStandardScheme(context);
        if (null == stdSchemeObj) {
            return;
        }
        DynamicObject projectObj = context.getView().getParentView().getModel().getDataEntity();
        DynamicObject proSchemeObj = this.getProjectScheme(projectObj, stdSchemeObj);
        if (null != proSchemeObj) {
            String entryStatus = context.getView().getModel().getEntryRowEntity("entryentity", context.getIndex()).getString("entrystatus");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("index", context.getIndex());
            paramMap.put("entrystatus", entryStatus);
            context.getView().getModel().setValue("proscheme", (Object)proSchemeObj.getLong("id"), context.getIndex());
            if ("A".equals(entryStatus)) {
                OpenFormUtils.openBillPage((IFormView)context.getView(), (String)"src_scheme2", (Object)proSchemeObj.getLong("id"), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, paramMap, null);
            } else {
                OpenFormUtils.openBillPage((IFormView)context.getView(), (String)"src_scheme2", (Object)proSchemeObj.getLong("id"), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, paramMap, null);
            }
        }
    }

    private DynamicObject getStandardScheme(ExtPluginContext context) {
        if (StringUtils.isBlank((Object)context.getView().getParentView().getModel().getDataEntity().get("billno"))) {
            context.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\uff0c\u518d\u7ef4\u62a4\u9879\u76ee\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcProjectSchemeHandler_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return null;
        }
        EntryGrid grid = (EntryGrid)context.getView().getControl("entryentity");
        int[] indexs = grid.getSelectRows();
        if (null == indexs || indexs.length == 0) {
            context.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c\uff0c\u518d\u7ef4\u62a4\u9879\u76ee\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcProjectSchemeHandler_3", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObject row = context.getView().getModel().getEntryRowEntity("entryentity", indexs[0]);
        context.setIndex(indexs[0]);
        DynamicObject stdSchemeObj = row.getDynamicObject("scheme");
        if (null == stdSchemeObj) {
            context.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bc4\u6807\u65b9\u6848\uff0c\u518d\u7ef4\u62a4\u9879\u76ee\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcProjectSchemeHandler_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        return stdSchemeObj;
    }

    private DynamicObject getProjectScheme(DynamicObject projectObj, DynamicObject stdSchemeObj) {
        QFilter qfilter = new QFilter("projectid", "=", (Object)projectObj.getLong("id"));
        qfilter.and("schemeid", "=", (Object)stdSchemeObj.getLong("id"));
        DynamicObject proSchemeObj = QueryServiceHelper.queryOne((String)"src_scheme", (String)"id", (QFilter[])qfilter.toArray());
        if (null != proSchemeObj) {
            return proSchemeObj;
        }
        return this.createProjectScheme(projectObj, stdSchemeObj);
    }

    private DynamicObject createProjectScheme(DynamicObject projectObj, DynamicObject schemeObj) {
        DynamicObject stdSchemeObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)schemeObj), (String)"src_scheme");
        DynamicObject proSchemeObj = BusinessDataServiceHelper.newDynamicObject((String)"src_scheme");
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)proSchemeObj);
        PdsCommonUtils.copyDynamicObjectValue((DynamicObject)stdSchemeObj, (DynamicObject)proSchemeObj, (List)properties, Collections.emptySet(), (int)-1);
        this.setSpecialValue(projectObj, stdSchemeObj, proSchemeObj);
        PdsCommonUtils.copyDynamicObjectEntryValue(null, (DynamicObject)stdSchemeObj, (String)"entryentity", (DynamicObject)proSchemeObj, (String)"entryentity", null);
        PdsCommonUtils.copyDynamicObjectEntryValue(null, (DynamicObject)stdSchemeObj, (String)"entryentity_para", (DynamicObject)proSchemeObj, (String)"entryentity_para", null);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)proSchemeObj);
        return proSchemeObj;
    }

    private void setSpecialValue(DynamicObject projectObj, DynamicObject stdSchemeObj, DynamicObject proSchemeObj) {
        proSchemeObj.set("projectid", (Object)projectObj.getLong("id"));
        proSchemeObj.set("schemeid", (Object)stdSchemeObj.getLong("id"));
        proSchemeObj.set("number", (Object)(stdSchemeObj.getString("number") + '_' + projectObj.getString("billno")));
        proSchemeObj.set("issyspreset", (Object)"0");
        proSchemeObj.set("isv_id", null);
        proSchemeObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        proSchemeObj.set("createtime", (Object)TimeServiceHelper.now());
    }
}

