/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcWinruleUtils;

public class SrcRatioTypeChgEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return;
        }
        this.setRatioType();
        this.createEntryEntity();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (parentView == null) {
            return;
        }
        this.setOrderRatioFieldEnable(0, this.getModel().getEntryRowCount("entryentity"));
        String newRatioType = this.getModel().getDataEntity().getString("newratiotype");
        this.setFieldMastInput(newRatioType);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName;
        super.propertyChanged(evt);
        switch (propertyName = evt.getProperty().getName()) {
            case "newratiotype": {
                this.setFieldMastInput(String.valueOf(evt.getChangeSet()[0].getNewValue()));
                this.clearValueByRatioType();
                this.setOrderRatioFieldEnable(0, this.getModel().getEntryRowCount("entryentity"));
                break;
            }
            case "entrywinerqty": 
            case "entryalterqty": 
            case "entrytrainqty": {
                this.setOrderRatioFieldEnable(evt.getChangeSet()[0].getRowIndex(), evt.getChangeSet()[0].getRowIndex() + 1);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return;
        }
        int count = this.getModel().getEntryRowCount("entryentity");
        this.getModel().setValue("project", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj), count - 1);
        this.setOrderRatioFieldEnable(count - 1, count);
    }

    private void setFieldMastInput(String newratiotype) {
        PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"package", (boolean)false);
        PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"purlist", (boolean)false);
        if (Objects.equals(newratiotype, "3")) {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"package", (boolean)true);
        }
        if (Objects.equals(newratiotype, "4")) {
            PdsCommonUtils.setFieldMastInput((IFormView)this.getView(), (String)"purlist", (boolean)true);
        }
    }

    private void clearValueByRatioType() {
        String newRatioType = PdsCommonUtils.object2String((Object)this.getModel().getDataEntity().get("newratiotype"), (String)"1");
        if (!newRatioType.equals("3")) {
            this.setEntryValueNull("package");
        } else if (!newRatioType.equals("4")) {
            this.setEntryValueNull("purlist");
        }
    }

    private void setEntryValueNull(String fieldName) {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        this.getModel().beginInit();
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue(fieldName, null, i);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void setRatioType() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)parentView.getModel().getDataEntity().getDynamicObject("project")), (String)"src_project_rule");
        String ratioType = projectObj.getString("ratiotype");
        model.setValue("ratiotype", (Object)ratioType);
        model.setValue("newratiotype", (Object)ratioType);
    }

    private void setOrderRatioFieldEnable(int indexFrom, int indexTo) {
        for (int rowIndex = indexFrom; rowIndex < indexTo; ++rowIndex) {
            int i;
            int trainQty;
            int alterQty;
            int winerQty = (Integer)this.getModel().getValue("entrywinerqty", rowIndex);
            int qty = winerQty + (alterQty = ((Integer)this.getModel().getValue("entryalterqty", rowIndex)).intValue()) + (trainQty = ((Integer)this.getModel().getValue("entrytrainqty", rowIndex)).intValue());
            if (qty == 0) {
                qty = 5;
            }
            for (i = 1; i <= qty; ++i) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"orderratio" + SrcWinruleUtils.formatInt((int)i, (boolean)true)});
            }
            for (i = qty + 1; i <= 10; ++i) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"orderratio" + SrcWinruleUtils.formatInt((int)i, (boolean)true)});
                this.getModel().setValue("orderratio" + SrcWinruleUtils.formatInt((int)i, (boolean)true), null, rowIndex);
            }
        }
    }

    private void createEntryEntity() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return;
        }
        DynamicObject projectRuleObj = TemplateUtil.getComponentData((String)String.valueOf(projectObj.getLong("id")), (String)"src_project_rule");
        if (null == projectRuleObj) {
            return;
        }
        DynamicObjectCollection entryentity = projectRuleObj.getDynamicObjectCollection("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (DynamicObject entry : entryentity) {
            ts.set("project", entry.get("project.id"), i);
            ts.set("package", entry.get("package.id"), i);
            ts.set("purlist", entry.get("purlist.id"), i);
            ts.set("entryalterqty", entry.get("entryalterqty"), i);
            ts.set("entrytrainqty", entry.get("entrytrainqty"), i);
            ts.set("entrywinerqty", entry.get("entrywinerqty"), i);
            ts.set("orderratio01", entry.get("orderratio01"), i);
            ts.set("orderratio02", entry.get("orderratio02"), i);
            ts.set("orderratio03", entry.get("orderratio03"), i);
            ts.set("orderratio04", entry.get("orderratio04"), i);
            ts.set("orderratio05", entry.get("orderratio05"), i);
            ts.set("orderratio06", entry.get("orderratio06"), i);
            ts.set("orderratio07", entry.get("orderratio07"), i);
            ts.set("orderratio08", entry.get("orderratio08"), i);
            ts.set("orderratio09", entry.get("orderratio09"), i);
            ts.set("orderratio10", entry.get("orderratio10"), i);
            ts.set("orderratio", entry.get("orderratio"), i);
            ts.set("surplusratio", entry.get("surplusratio"), i);
            ts.set("seq", (Object)(i + 1), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void registerListener(EventObject e) {
        BasedataEdit purlistEdit;
        super.registerListener(e);
        BasedataEdit packageEdit = (BasedataEdit)this.getView().getControl("package");
        if (null != packageEdit) {
            packageEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (purlistEdit = (BasedataEdit)this.getView().getControl("purlist"))) {
            purlistEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return;
        }
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "package": {
                QFilter packageQFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
                ListShowParameter packageShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                packageShowParameter.getListFilterParameter().setFilter(packageQFilter);
                break;
            }
            case "purlist": {
                QFilter purlistQFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
                purlistQFilter.and("billtype", "=", (Object)"1");
                ListShowParameter purlistShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                purlistShowParameter.getListFilterParameter().setFilter(purlistQFilter);
                break;
            }
        }
    }
}

