/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.patternfilter.PatternFilterUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcSchemeChgEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        this.setOldSchemeData();
    }

    public void afterBindData(EventObject e) {
        this.setFieldVisible();
        this.setFieldEnable();
    }

    private void setFieldEnable() {
        DynamicObject projectObj = this.getProjectObj();
        if (null == projectObj) {
            return;
        }
        if (!projectObj.getString("sourcetype.number").equals(SourceTypeEnums.VIE.getValue())) {
            ((BasedataEdit)this.getView().getControl("winrule")).setMustInput(true);
        }
    }

    private void setFieldVisible() {
        Set sourceTypeSet;
        DynamicObject projectObj = this.getProjectObj();
        if (null == projectObj) {
            return;
        }
        String sourceType = projectObj.getString("sourcetype.number");
        if (sourceType.equals(SourceTypeEnums.VIE.getValue()) || sourceType.equals(SourceTypeEnums.ELECTRONIC_AUCTION.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"prewinrule"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"winrule"});
        }
        if (!(sourceTypeSet = PdsCommonUtils.buildSet((String[])new String[]{SourceTypeEnums.BID.getValue(), SourceTypeEnums.BID2.getValue(), SourceTypeEnums.BID3.getValue(), SourceTypeEnums.BID4.getValue()})).contains(sourceType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"preruleassess"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ruleassess"});
        }
    }

    private DynamicObject getProjectObj() {
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (null == parentView) {
            return null;
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return null;
        }
        return projectObj;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit winruleEdit = (BasedataEdit)this.getView().getControl("winrule");
        if (null != winruleEdit) {
            winruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit newSchemeEdit = (BasedataEdit)this.getControl("scheme");
        newSchemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String objectName = evt.getProperty().getName();
        DynamicObject projectObj = this.getProjectObj();
        if (null == projectObj) {
            return;
        }
        switch (objectName) {
            case "winrule": {
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)projectObj, (String)"src_project_rule_winrule", null);
                break;
            }
            case "scheme": {
                QFilter qFilter = PatternFilterUtils.getSchemeFilter((IFormView)this.getView());
                showParameter.getListFilterParameter().setFilter(qFilter);
                String orderBy = "matchfield desc,number";
                showParameter.getListFilterParameter().setOrderBy(orderBy);
                break;
            }
        }
    }

    private void setOldSchemeData() {
        IFormView parentView = SrcBidChangeUtil.getParentView((IFormView)this.getView());
        if (null == parentView) {
            return;
        }
        DynamicObject projectObj = parentView.getModel().getDataEntity().getDynamicObject("project");
        if (null == projectObj) {
            return;
        }
        this.getModel().setValue("prewinrule", (Object)projectObj.getLong("winrule.id"));
        this.getModel().setValue("winrule", (Object)projectObj.getLong("winrule.id"));
        this.getModel().setValue("preruleassess", (Object)projectObj.getString("ruleassess"));
        this.getModel().setValue("ruleassess", (Object)projectObj.getString("ruleassess"));
        this.getModel().setValue("previetype", (Object)projectObj.getString("vietype"));
        this.getModel().setValue("vietype", (Object)projectObj.getString("vietype"));
        this.getModel().setValue("sourcetype", (Object)projectObj.getLong("sourcetype.id"));
        this.getModel().setValue("prescheme", (Object)projectObj.getLong("scheme.id"));
        this.getModel().setValue("scheme", (Object)projectObj.getLong("scheme.id"));
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        switch (evt.getProperty().getName()) {
            case "winrule": 
            case "ruleassess": {
                this.getModel().setValue("scheme", null);
                break;
            }
        }
    }
}

