/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcSchemeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultValue();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (StringUtils.isBlank((Object)this.getModel().getValue("schemetype"))) {
            this.getModel().setValue("schemetype", (Object)this.getSchemeType());
            PdsCommonUtils.saveDynamicObjects((DynamicObject)this.getModel().getDataEntity(true));
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.setIndexTypeMustInput();
        this.setBaseDataCombListValue();
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        switch (evt.getProperty().getName()) {
            case "type": {
                this.setIndexTypeMustInput();
                break;
            }
            case "indexlib": {
                this.setIsOpinion(evt);
                break;
            }
            case "valuebizobject": {
                this.setBaseDataCombListValue(evt.getChangeSet()[0].getRowIndex());
                break;
            }
        }
    }

    private void setDefaultValue() {
        String schemeType = this.getSchemeType();
        if (StringUtils.isBlank((Object)this.getModel().getValue("schemetype"))) {
            this.getModel().setValue("schemetype", (Object)schemeType);
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue("type"))) {
            switch (schemeType) {
                case "1": {
                    this.getModel().setValue("type", (Object)PdsCommonUtils.getBasedataIdByNumber((String)"src_indexclass", (String)"SYS001"));
                    break;
                }
                case "2": {
                    this.getModel().setValue("type", (Object)PdsCommonUtils.getBasedataIdByNumber((String)"src_indexclass", (String)"SYS004"));
                    break;
                }
                case "3": {
                    this.getModel().setValue("type", (Object)PdsCommonUtils.getBasedataIdByNumber((String)"src_indexclass", (String)"SYS005"));
                    break;
                }
                case "4": {
                    this.getModel().setValue("type", (Object)PdsCommonUtils.getBasedataIdByNumber((String)"src_indexclass", (String)"SYS008"));
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String operateKey = ((AbstractOperate)evt.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            if (this.checkSumScore()) {
                this.setEntryValue();
                if ("4".equals(this.getModel().getDataEntity().getString("schemetype"))) {
                    this.getModel().setValue("matchfield", (Object)ExtFilterUtils.getMatchFields((IFormView)this.getView(), (String)"src_evaluateconfig"));
                } else {
                    this.getModel().setValue("matchfield", (Object)ExtFilterUtils.getMatchFields((IFormView)this.getView(), (String)"src_bidopen_config"));
                }
            } else {
                evt.setCancel(true);
            }
        }
    }

    private boolean checkSumScore() {
        DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        BigDecimal sumScore = BigDecimal.ZERO;
        StringBuilder sb = new StringBuilder();
        int allBizCount = 0;
        int isScoreTaskCount = 0;
        for (DynamicObject row : rows) {
            BigDecimal score = row.getBigDecimal("score");
            BigDecimal lowvalue = row.getBigDecimal("lowvalue");
            BigDecimal hightvalue = row.getBigDecimal("hightvalue");
            BigDecimal threshold = row.getBigDecimal("threshold");
            String indexName = row.getString("index");
            boolean isThreshold = row.getBoolean("isthreshold");
            boolean isFitted = row.getBoolean("isfitted");
            if (lowvalue.compareTo(BigDecimal.ZERO) > 0 && lowvalue.compareTo(score) > 0) {
                sb = sb.append(indexName).append(": ").append(ResManager.loadKDString((String)"\u201c\u63d0\u9192\u503c(<=)\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u6807\u51c6\u5206\u503c\u201d\u3002", (String)"SrcSchemeEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0])).append("\n");
            }
            if (hightvalue.compareTo(BigDecimal.ZERO) > 0 && hightvalue.compareTo(score) > 0) {
                sb = sb.append(indexName).append(": ").append(ResManager.loadKDString((String)"\u201c\u63d0\u9192\u503c(>=)\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u6807\u51c6\u5206\u503c\u201d\u3002", (String)"SrcSchemeEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0])).append("\n");
            }
            if (lowvalue.compareTo(BigDecimal.ZERO) > 0 && lowvalue.compareTo(hightvalue) >= 0) {
                sb = sb.append(indexName).append(": ").append(ResManager.loadKDString((String)"\u201c\u63d0\u9192\u503c(<=)\u201d\u5e94\u5c0f\u4e8e\u201c\u63d0\u9192\u503c(>=)\u201d\u3002", (String)"SrcSchemeEdit_2", (String)"scm-src-formplugin", (Object[])new Object[0])).append("\n");
            }
            if (!(isThreshold && isFitted || score.compareTo(BigDecimal.ZERO) > 0)) {
                sb = sb.append(indexName).append(": ").append(ResManager.loadKDString((String)"\u975e\u95e8\u69db\u503c\u3001\u975e\u7b26\u5408\u9879\u7684\u6807\u51c6\u5206\u503c\u5e94\u5927\u4e8e0\u3002", (String)"SrcSchemeEdit_5", (String)"scm-src-formplugin", (Object[])new Object[0])).append("\n");
            }
            if (isThreshold && !isFitted && threshold.compareTo(BigDecimal.ZERO) <= 0) {
                sb = sb.append(indexName).append(": ").append(ResManager.loadKDString((String)"\u95e8\u69db\u503c\u5e94\u5927\u4e8e0\u3002", (String)"SrcSchemeEdit_6", (String)"scm-src-formplugin", (Object[])new Object[0])).append("\n");
            }
            if (threshold.compareTo(BigDecimal.ZERO) > 0 && threshold.compareTo(score) > 0 && score.compareTo(BigDecimal.ZERO) > 0) {
                sb = sb.append(indexName).append(": ").append(ResManager.loadKDString((String)"\u95e8\u69db\u503c\u5e94\u5c0f\u4e8e\u6807\u51c6\u5206\u503c\u3002", (String)"SrcSchemeEdit_3", (String)"scm-src-formplugin", (Object[])new Object[0])).append("\n");
            }
            sumScore = sumScore.add(score);
            String baseType = row.getString("indextype.basetype");
            if (!"2".equals(baseType)) continue;
            ++allBizCount;
            if (!row.getBoolean("isscoretask")) continue;
            ++isScoreTaskCount;
        }
        this.getModel().setValue("schemescore", (Object)sumScore);
        String scoremethod = this.getModel().getDataEntity().getString("scoremethod");
        if (!"3".equals(scoremethod) && sumScore.compareTo(new BigDecimal("100")) != 0) {
            sb.append(ResManager.loadKDString((String)"\u6807\u51c6\u5206\u503c\u5408\u8ba1\u9700\u4e3a\u6ee1\u5206100\u5206\u3002", (String)"SrcSchemeEdit_4", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
        if (allBizCount > 0 && isScoreTaskCount > 0 && allBizCount != isScoreTaskCount) {
            sb.append(ResManager.loadKDString((String)"\u5728\u540c\u4e00\u4e2a\u65b9\u6848\u4e2d\uff0c\u5546\u52a1\u6307\u6807\u7c7b\u578b\u8981\u4e48\u90fd\u4e0b\u8fbe\u8bc4\u6807\u4efb\u52a1\uff0c\u8981\u4e48\u90fd\u4e0d\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8\u90e8\u5206\u4e0b\u8fbe\uff0c\u90e8\u5206\u4e0d\u4e0b\u8fbe\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u3002", (String)"SrcSchemeEdit_7", (String)"scm-src-formplugin", (Object[])new Object[0]));
        } else if (isScoreTaskCount > 0) {
            this.getModel().setValue("isbizscore", (Object)"1");
        } else {
            this.getModel().setValue("isbizscore", (Object)"0");
        }
        if (sb.length() > 0) {
            this.getView().showErrorNotification(sb.toString());
            return false;
        }
        return true;
    }

    private void setEntryValue() {
        DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int index = 0; index < rows.size(); ++index) {
            if (this.isSynthesizeScore()) {
                this.getModel().setValue("indexclass", (Object)((DynamicObject)rows.get(index)).getLong("indextype.id"), index);
            } else {
                this.getModel().setValue("indextype", (Object)this.getModel().getDataEntity().getLong("type.id"), index);
                this.getModel().setValue("indexclass", (Object)this.getModel().getDataEntity().getLong("type.id"), index);
            }
            this.getModel().setValue("entryscoremethod", this.getModel().getValue("scoremethod"), index);
            this.getModel().setValue("entryschemescore", this.getModel().getValue("schemescore"), index);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String op_key;
        super.afterDoOperation(evt);
        switch (op_key = evt.getOperateKey()) {
            case "indexlib": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_index", (ShowType)ShowType.MainNewTabPage, null, null, null);
                break;
            }
            case "grade": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_expertgrade", (ShowType)ShowType.MainNewTabPage, null, null, null);
                break;
            }
            case "save": {
                DynamicObjectCollection rows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                if (null == rows || rows.size() == 0) {
                    return;
                }
                List pkIds = rows.stream().map(e -> e.getPkValue()).map(PdsCommonUtils::object2Long).collect(Collectors.toList());
                String selectFields = DynamicObjectUtil.getSelectfields((String)"src_indexf7", (boolean)false);
                QFilter qfilter = new QFilter("id", "in", pkIds);
                DynamicObject[] indexObjs = BusinessDataServiceHelper.load((String)"src_indexf7", (String)selectFields, (QFilter[])qfilter.toArray());
                PdsCommonUtils.saveDynamicObjects((DynamicObject[])indexObjs);
                this.resetAptitudeConfig();
                break;
            }
        }
    }

    public void resetAptitudeConfig() {
        if (this.getModel().getDataEntity().getLong("projectid") > 0L) {
            int index = PdsCommonUtils.object2Integer((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"index"));
            if ("src_aptitudeconfig".equals(this.getView().getParentView().getEntityId()) || "src_aptitudeconfig2".equals(this.getView().getParentView().getEntityId())) {
                this.getView().getParentView().getModel().setValue("sumscore", this.getModel().getValue("sumscore"), index);
            }
            this.getView().getParentView().getModel().setValue("expertcount", this.getModel().getValue("expertcount"), index);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit indexLib;
        super.registerListener(e);
        BasedataEdit type = (BasedataEdit)this.getControl("type");
        if (Objects.nonNull(type)) {
            type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(indexLib = (BasedataEdit)this.getControl("indexlib"))) {
            indexLib.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter qFilter = null;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "type": {
                qFilter = new QFilter("basetype", "in", this.getBaseType());
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "indexlib": {
                String schemeType = PdsCommonUtils.object2String((Object)this.getModel().getValue("schemetype"), (String)"1");
                if (!"1".equals(schemeType) || this.isSynthesizeScore()) break;
                String typeNumber = this.getModel().getDataEntity().getString("type.number");
                qFilter = new QFilter("indexclass.number", "=", (Object)typeNumber);
                listShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    private String getSchemeType() {
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(parentView)) {
            return "";
        }
        Map params = parentView.getFormShowParameter().getCustomParams();
        return PdsCommonUtils.object2String(params.get("schemetype"), (String)"1");
    }

    private Set<String> getBaseType() {
        String schemeType;
        HashSet<String> baseTypeSet = new HashSet<String>(3);
        switch (schemeType = this.getSchemeType()) {
            case "1": {
                baseTypeSet.add("1");
                baseTypeSet.add("2");
                baseTypeSet.add("3");
                baseTypeSet.add("6");
                break;
            }
            case "2": {
                baseTypeSet.add("4");
                baseTypeSet.add("7");
                break;
            }
            case "3": {
                baseTypeSet.add("5");
                break;
            }
            case "4": {
                baseTypeSet.add("8");
                break;
            }
        }
        return baseTypeSet;
    }

    private boolean isSynthesizeScore() {
        String baseType = PdsCommonUtils.object2String((Object)this.getModel().getDataEntity().get("type.basetype"), (String)"");
        return baseType.equals("6");
    }

    private void setIndexTypeMustInput() {
        if (this.isSynthesizeScore()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"indextype"});
            ((BasedataEdit)this.getView().getControl("indextype")).setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"indextype"});
            ((BasedataEdit)this.getView().getControl("indextype")).setMustInput(false);
        }
    }

    private void setIsOpinion(PropertyChangedArgs evt) {
        Object newValue = evt.getChangeSet()[0].getNewValue();
        int index = evt.getChangeSet()[0].getRowIndex();
        if (null == newValue) {
            this.getModel().setValue("isopinion", (Object)"0", index);
            return;
        }
        DynamicObjectCollection rows = ((DynamicObject)newValue).getDynamicObjectCollection("entryentity");
        if (null == rows || rows.size() == 0) {
            this.getModel().setValue("isopinion", (Object)"0", index);
        } else {
            this.getModel().setValue("isopinion", (Object)"1", index);
        }
    }

    private void setBaseDataCombListValue() {
        for (int index = 0; index < this.getModel().getEntryRowCount("entryentity"); ++index) {
            this.setBaseDataCombListValue(index);
        }
    }

    private void setBaseDataCombListValue(int index) {
        DynamicObject valuebizobject;
        DynamicObject row = this.getModel().getEntryRowEntity("entryentity", index);
        if ("9".equals(row.getString("valuetype")) && null != (valuebizobject = row.getDynamicObject("valuebizobject"))) {
            PdsCommonUtils.setCombListValue((IFormView)this.getView(), (String)valuebizobject.getString("number"), (String)"fieldname");
        }
    }
}

