/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.src.common.calc.analy.SrcAnalyFacade;

public class SrcSourcePlanEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private boolean isChanging = false;

    private void packageEntryData(PackageDataEvent event) {
        if (event.getRowData().getLong("srcbillid") == 0L) {
            event.getNoLinkKey().add("planitem");
        }
    }

    public void beforeBindData(EventObject evt) {
        this.setDefaultScheme();
        this.setBizItemEnable();
    }

    public void setDefaultScheme() {
        IFormView parentView = this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        if (null == this.getModel().getValue("planscheme") && ("src_project".equals(parentView.getEntityId()) || "src_preproject".equals(parentView.getEntityId()))) {
            DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("projectf7");
            SchemeFilterUtils.setSchemeDefaultValue((IFormView)this.getView(), (DynamicObject)projectObj, (String)"src_planscheme_filter", (String)"planscheme", null);
        }
    }

    public void setBizItemEnable() {
        String openStatus = PdsCommonUtils.object2String((Object)this.getModel().getDataEntity().get("projectf7.openstatus"), (String)"1");
        String billStatus = PdsCommonUtils.object2String((Object)this.getModel().getDataEntity().get("projectf7.billstatus"), (String)"A");
        if (PdsCommonUtils.isTnd((String)this.getView().getFormShowParameter().getAppId(), (String)RequestContext.get().getUserType()) || "wftask".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"planscheme", "newentry1", "deleteentry1", "moveentryup", "moveentrydown", "itemanalyse"});
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"planitem", "begindate", "enddate"});
        } else if (!BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) || !BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"planscheme", "newentry1", "deleteentry1", "moveentryup", "moveentrydown"});
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"planitem", "begindate", "enddate"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "itemanalyse": {
                long projectId = this.getModel().getDataEntity().getLong("projectf7.id");
                QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_planitemf7", (ShowType)ShowType.MainNewTabPage, (Map)SrcAnalyFacade.getFormShowPara((long)projectId), (QFilter)projectFilter, null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String objectName;
        switch (objectName = evt.getProperty().getName()) {
            case "planscheme": {
                DynamicObject projectObj = this.getModel().getDataEntity().getDynamicObject("projectf7");
                SchemeFilterUtils.setSchemeF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)projectObj, (String)"src_planscheme_filter", null);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        switch (evt.getProperty().getName()) {
            case "planscheme": {
                this.createPlanItemEntry();
                break;
            }
            case "begindate": 
            case "enddate": 
            case "hours": {
                this.calculateDate(evt);
                break;
            }
        }
    }

    public void calculateDate(PropertyChangedArgs evt) {
        if (this.isChanging) {
            return;
        }
        this.isChanging = true;
        DynamicObject row = this.getModel().getEntryRowEntity("entryentity", evt.getChangeSet()[0].getRowIndex());
        SrcDateUtils.calculateDateTimes((String)evt.getProperty().getName(), (DynamicObject)row, (String)"begindate", (String)"enddate", (String)"hours");
        this.getView().updateView("entryentity", evt.getChangeSet()[0].getRowIndex());
        this.isChanging = false;
    }

    public void createPlanItemEntry() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        DynamicObject schemeObj = this.getModel().getDataEntity().getDynamicObject("planscheme");
        if (null == schemeObj) {
            return;
        }
        DynamicObjectCollection rows = schemeObj.getDynamicObjectCollection("entryentity");
        if (rows.size() == 0) {
            return;
        }
        boolean isNotDemand = null == this.getView().getParentView().getModel().getValue("source");
        model.deleteEntryData("entryentity");
        model.beginInit();
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)((DynamicObject)rows.get(0)));
        HashSet<String> excFields = new HashSet<String>();
        excFields.add("id");
        excFields.add("fseq");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject row : rows) {
            String itemNumber = row.getString("planitem.number");
            if (isNotDemand && ("SYS001".equals(itemNumber) || "SYS002".equals(itemNumber))) continue;
            for (String pro : properties) {
                if (excFields.contains(pro)) continue;
                try {
                    if (row.get(pro) instanceof DynamicObject) {
                        ts.set(pro, row.getDynamicObject(pro).getPkValue(), index);
                        continue;
                    }
                    ts.set(pro, row.get(pro), index);
                }
                catch (Exception e) {
                    BizLog.log((String)e.getMessage());
                }
            }
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit templateEdit = (BasedataEdit)this.getControl("planscheme");
        templateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addPackageDataListener(this::packageEntryData);
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "planitem": {
                this.openTargetBill(args);
                break;
            }
        }
    }

    public void openTargetBill(HyperLinkClickEvent args) {
        int rowIndex = args.getRowIndex();
        DynamicObject row = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        long billId = row.getLong("srcbillid");
        if (billId > 0L) {
            long nodeId = row.getLong("planitem.biznode.id");
            String entityName = row.getString("srcbilltype");
            if (StringUtils.isBlank((CharSequence)entityName)) {
                entityName = PdsCommonUtils.getNodeEntityNameById((long)nodeId);
            }
            if (null != entityName) {
                try {
                    OpenFormUtils.openBillPage((IFormView)this.getView(), (String)entityName, (Object)billId, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u67e5\u770b\u7684\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u67e5\u770b\u6743\u9650\u3002", (String)"SrcSourcePlanEdit_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u53ea\u80fd\u67e5\u770b\u5df2\u5b8c\u6210\u7684\u5355\u636e\u3002", (String)"SrcSourcePlanEdit_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
        }
    }
}

