/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.supplierfilter.SupplierFilterUtils;

public class SrcSupplierBatchPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("project", paraMap.get("project"));
        this.setPackageDefaultValue();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count < 2) {
            this.setPackageDefaultValue();
        } else {
            this.getModel().setValue("package", this.getModel().getValue("package", count - 2), count - 1);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit pkgEdit = (BasedataEdit)this.getControl("package");
        pkgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supControl = (BasedataEdit)this.getView().getControl("supplier");
        if (null != supControl) {
            supControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String opkey;
        super.beforeDoOperation(evt);
        switch (opkey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": {
                DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
                if (rows == null || rows.size() == 0) {
                    return;
                }
                this.getView().returnDataToParent((Object)rows);
                break;
            }
        }
    }

    private void setPackageDefaultValue() {
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count == 0) {
            return;
        }
        long projectId = this.getModel().getDataEntity().getLong("project.id");
        if (0L == projectId) {
            return;
        }
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_packagef7", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"packagename");
        List<Object> packageList = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
        this.getModel().setValue("package", (Object)packageList.toArray(new Object[packageList.size()]), count - 1);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        String key = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (key) {
            case "package": {
                String objectName = evt.getProperty().getName();
                long projectId = model.getDataEntity().getLong("project.id");
                if (!StringUtils.equals((CharSequence)objectName, (CharSequence)"package")) break;
                showParameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter qFilter = new QFilter("project", "=", (Object)projectId);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "supplier": {
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                String supplierType = SupplierFilterUtils.inviteSupplierType();
                if (null == supplierType) break;
                HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>(1);
                paramMap.put("ismustinput", true);
                SupplierFilterUtils.setSupplierF7Filter((BeforeF7SelectEvent)evt, (DynamicObject)this.getModel().getDataEntity().getDynamicObject("project"), (String)("src_project_" + supplierType + '_' + "filter"), paramMap);
                break;
            }
        }
    }
}

