/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.ext;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.pds.common.extplugin.IExtendPlugin;
import kd.scm.pds.common.util.SupplierUtil;

public class SrcContractToContractValidator
implements IExtendPlugin {
    public String validate(IFormView view, BeforeDoOperationEventArgs args) {
        StringBuilder sb = new StringBuilder();
        if (view != null) {
            EntryGrid grid = (EntryGrid)view.getControl("entryentity");
            int[] selectRows = grid.getSelectRows();
            HashMap<Integer, Integer> selectMap = new HashMap<Integer, Integer>(selectRows.length);
            DynamicObjectCollection entryentity = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (int i = 0; i < selectRows.length; ++i) {
                selectMap.put(selectRows[i], i);
            }
            long[] selectEntryId = new long[selectRows.length];
            boolean flag = true;
            String source = "";
            boolean isSelect = false;
            if (selectRows != null && selectRows.length > 0) {
                isSelect = true;
            }
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject info = (DynamicObject)entryentity.get(i);
                if (isSelect && !selectMap.containsKey(i)) continue;
                if (isSelect) {
                    long entryId;
                    selectEntryId[((Integer)selectMap.get((Object)Integer.valueOf((int)i))).intValue()] = entryId = info.getLong("id");
                }
                if (!(flag = SupplierUtil.isBdSupplier((DynamicObject)info))) break;
                if (SupplierUtil.isQZGYS((long)info.getLong("supplier_id"))) {
                    sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u4f9b\u5e94\u5546\u4e3a\u6f5c\u5728\u4f9b\u5e94\u5546\u3002", (String)"SrcContractToContractValidator_4", (String)"scm-src-formplugin", (Object[])new Object[0]), info.getInt("seq"))).append("\r\n");
                }
                String reqsource = info.getString("reqsource");
                source = this.validateReqSource(args, source, reqsource);
                if (!args.isCancel()) continue;
                view.showErrorNotification(ResManager.loadKDString((String)"\u591a\u79cd\u6570\u636e\u6765\u6e90\u7684\u7533\u8bf7\u5355\u65e0\u6cd5\u4e0b\u63a8\u5408\u540c\u3002", (String)"SrcContractToContractValidator_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return "";
            }
            if (!StringUtils.isBlank((CharSequence)sb.toString())) {
                args.setCancel(true);
                view.showErrorNotification(sb.toString());
            }
            if (!flag) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5148\u7ef4\u62a4\u6b63\u5f0f\u4f9b\u5e94\u5546\u6570\u636e\u540e\u518d\u5173\u8054\u751f\u6210\u5408\u540c\u3002", (String)"SrcContractToContractValidator_2", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return "";
            }
            view.getPageCache().put("source", source);
            view.getPageCache().put("selectRows", JacksonJsonUtil.toJSON((Object)selectEntryId));
        }
        if (ApiConfigUtil.hasXKScmConfig()) {
            return "XK";
        }
        return "EAS";
    }

    protected String validateReqSource(BeforeDoOperationEventArgs args, String source, String reqSource) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return reqSource;
        }
        if (!source.equals(reqSource)) {
            args.setCancel(true);
        }
        return source;
    }

    protected void validateQty(IFormView view, DynamicObject info, StringBuilder sb) {
        if (info != null && view != null) {
            BigDecimal qty = info.getBigDecimal("cfmbaseqty");
            BigDecimal orderqty = info.getBigDecimal("contractbaseqty");
            boolean iscontrolqty = info.getBoolean("iscontrolqty");
            BigDecimal subtract = qty.subtract(orderqty);
            if (iscontrolqty && subtract.compareTo(BigDecimal.ZERO) <= 0) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c,\u5b9a\u6807\u57fa\u672c\u6570\u91cf\u4e0d\u7b26\u5408\u4e0b\u63a8\u89c4\u5219\uff0c\u8bf7\u786e\u4fdd\u4e0b\u63a8\u540e\u5173\u8054\u5408\u540c\u57fa\u672c\u6570\u91cf\u5c0f\u4e8e\u7b49\u4e8e\u5b9a\u6807\u57fa\u672c\u6570\u91cf\u3002", (String)"SrcContractToContractValidator_3", (String)"scm-src-formplugin", (Object[])new Object[0]), info.getInt("seq"))).append("\r\n");
            }
        }
    }
}

