/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.list;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCostDetailUtils;
import kd.scm.src.common.calc.analy.SrcAnalyContext;
import kd.scm.src.common.calc.analy.SrcAnalyFacade;

public class SrcCompareToolList
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        PdsCostDetailUtils.costDetailQuery((IFormView)this.getView(), (HyperLinkClickArgs)args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String projectId = this.getProjectId();
        if (null == projectId) {
            return;
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            if (!column.getFieldName().equals("project.bidname")) continue;
            column.setDefaultValue(projectId);
            break;
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        SrcAnalyContext context = null;
        Object contextObj = this.getView().getFormShowParameter().getCustomParam("analyse");
        if (contextObj != null) {
            context = (SrcAnalyContext)SerializationUtils.fromJsonString((String)((String)contextObj), SrcAnalyContext.class);
        } else {
            if (this.getPageCache().get("analyse") != null) {
                context = (SrcAnalyContext)SerializationUtils.fromJsonString((String)this.getPageCache().get("analyse"), SrcAnalyContext.class);
            }
            if (context == null) {
                SrcAnalyContext analyContext = new SrcAnalyContext();
                Object qfilter = this.getView().getFormShowParameter().getCustomParam("qfilter");
                if (null != qfilter) {
                    analyContext.setQfilter(QFilter.fromSerializedString((String)qfilter.toString()));
                }
                SrcAnalyFacade.initAnalyContext((SrcAnalyContext)analyContext);
                context = analyContext;
                this.getPageCache().put("analyse", SerializationUtils.toJsonString((Object)context));
            }
        }
        if (context == null) {
            return;
        }
        if ("project.bidname".equals(args.getFieldName())) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)context.getProjectSet()));
        }
        if ("package.packagename".equals(args.getFieldName())) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)context.getPackageSet()));
        }
        if ("category.name".equals(args.getFieldName())) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)context.getCategorySet()));
        }
        if ("supplier.name".equals(args.getFieldName())) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)context.getSupplierSet()));
        }
        if ("compkey.name".equals(args.getFieldName())) {
            args.addCustomQFilter(new QFilter("number", "in", (Object)context.getCompkeySet()));
        }
        super.filterColumnSetFilter(args);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter filters = new QFilter("project.id", ">", (Object)0L).and("purlist.id", ">", (Object)0L);
        qFilters.add(filters);
        qFilters.add(SrcAnalyFacade.getCompareToolFilterByUserId());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOpEvt) {
        super.beforeDoOperation(beforeDoOpEvt);
        AbstractOperate operate = (AbstractOperate)beforeDoOpEvt.getSource();
        String opKey = operate.getOperateKey();
        long billId = ListSelectUtils.selectOneFromPurlistF7((IFormView)this.getView());
        switch (opKey) {
            case "quotetendency": {
                QFilter projectFilter = new QFilter("project", "=", (Object)billId);
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_quotetendency", (ShowType)ShowType.MainNewTabPage, (Map)SrcAnalyFacade.getFormShowPara((long)billId), (QFilter)projectFilter, null);
                break;
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columnList = args.getListColumns();
        ArrayList<String> fieldList = new ArrayList<String>(columnList.size());
        for (int i = 0; i < columnList.size(); ++i) {
            fieldList.add(((IListColumn)columnList.get(i)).toString().replace('.', '_'));
        }
        SrcCompareToolList.getCache().put("fieldname", (Object)SerializationUtils.toJsonString(fieldList));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(RequestContext.get().getTenantId() + "_" + "src");
    }

    private String getProjectId() {
        SrcAnalyContext context;
        Object contextObj = this.getView().getFormShowParameter().getCustomParam("analyse");
        if (contextObj != null && (context = (SrcAnalyContext)SerializationUtils.fromJsonString((String)((String)contextObj), SrcAnalyContext.class)).getBillId() > 0L) {
            return String.valueOf(context.getBillId());
        }
        return null;
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"purlist")) {
                return rows;
            }
            List sList = rows.stream().filter(row -> null != row.getString("purlist.id")).filter(row -> null != row.getString("project.id")).sorted(Comparator.comparing(row -> row.getString("purlist.id"))).sorted(Comparator.comparing(row -> row.getString("project.id"))).collect(Collectors.toList());
            boolean isSetColor = false;
            String preKey = null;
            HashSet<String> pkSet = new HashSet<String>();
            for (DynamicObject row2 : sList) {
                String key = row2.getString("project.id") + "|" + row2.getString("purlist.id");
                if (preKey == null) {
                    preKey = key;
                }
                if (!StringUtils.equals((CharSequence)key, (CharSequence)preKey)) {
                    isSetColor = !isSetColor;
                    preKey = key;
                }
                if (!isSetColor) continue;
                pkSet.add(String.valueOf(row2.getPkValue()));
            }
            SrcCompareToolList.getCache().put("purlist", (Object)SerializationUtils.toJsonString(pkSet));
            return rows;
        }
    }
}

