/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.list;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreFacade;

public class SrcMyEvaluateTaskList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter userFilter = new QFilter("entry.subentry.scorer", "=", (Object)RequestContext.get().getCurrUserId());
        userFilter.or("entry.subentry.agent", "=", (Object)RequestContext.get().getCurrUserId());
        qFilters.add(userFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (null != result && !result.isSuccess()) {
            return;
        }
        HashMap<String, Object> paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (null == paramMap) {
            paramMap = new HashMap<String, Object>();
        }
        switch (operateKey) {
            case "scorebysup": {
                paramMap.put("scorebysup", "1");
            }
            case "evaluatehelper": {
                this.openScoreHelper(paramMap);
                break;
            }
            case "evaluateanalyse": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_evaluateanalyse", (ShowType)ShowType.MainNewTabPage, paramMap, null, null);
                break;
            }
            case "suggestion": {
                this.submitSuggestion();
                break;
            }
        }
    }

    public void openScoreHelper(Map<String, Object> paramMap) {
        Set<Long> taskIdSet = this.getEvaluateTaskIds();
        if (null == taskIdSet || taskIdSet.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u60a8\u7684\u6240\u6709\u8bc4\u5206\u4efb\u52a1\u5747\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u8bc4\u5206\u3002", (String)"SrcMyEvaluateTaskList_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
        } else {
            paramMap.put("scoretask", taskIdSet);
            paramMap.remove("pkId");
            OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_evaluateassist", (ShowType)ShowType.MainNewTabPage, paramMap, null);
        }
    }

    public Set<Long> getEvaluateTaskIds() {
        Set billIds = ListSelectUtils.getListSelectPrimaryKeys((IFormView)this.getView());
        QFilter qfilter = new QFilter("scorerscored", "=", (Object)"0");
        if (null != billIds && billIds.size() > 0) {
            qfilter.and("billid", "in", (Object)billIds);
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_evaluatetask_scorerf7", (String)"billid.id", (QFilter[])qfilter.toArray());
        return rows.stream().map(e -> e.getLong("billid.id")).collect(Collectors.toSet());
    }

    public void submitSuggestion() {
        long projectId = this.getEvaluateProjectId();
        if (projectId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u8bc4\u5206\u4efb\u52a1\u3002", (String)"SrcMyEvaluateTaskList_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
            return;
        }
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        paramMap.put("project", projectId);
        paramMap.put("basetype", "8");
        SrcScoreContext context = SrcScoreFacade.createScoreContext((IFormView)this.getView());
        context.setShowMessage(false);
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_submitopinion", (ShowType)ShowType.Modal, (Map)paramMap, null);
    }

    public long getEvaluateProjectId() {
        Set billIds = ListSelectUtils.getListSelectPrimaryKeys((IFormView)this.getView());
        if (null == billIds || billIds.size() == 0) {
            return 0L;
        }
        QFilter qfilter = new QFilter("billid", "in", (Object)billIds);
        DynamicObject row = QueryServiceHelper.queryOne((String)"src_evaluatetask_scorerf7", (String)"project.id", (QFilter[])qfilter.toArray());
        if (null == row) {
            return 0L;
        }
        return row.getLong("project.id");
    }
}

