/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.list;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.ListSelectUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsHyperLinkUtils;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcProjectList
extends AbstractListPlugin {
    private static final String BAR_DELETE = "delete";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "addnew": {
                String sourceType = PdsCommonUtils.getCustomParams((IFormView)this.getView());
                long billId = SrcProjectUtil.createNewBillId((String)"src_project", (String)sourceType, (long)0L, (boolean)false);
                if (billId <= 0L) break;
                SrcProjectList.openBillPage(this.getView(), "src_project", billId, BillOperationStatus.VIEW, ShowType.MainNewTabPage, null, null);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        long projectId = ListSelectUtils.selectOne((IFormView)this.getView());
        switch (key) {
            case "bidchange": {
                Object bidChangeId = SrcBidChangeUtil.getBidChangeObjId((String)"src_bidchange", (String)"project", (Object)projectId);
                if (bidChangeId == null) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("project", projectId);
                    SrcProjectList.openBillPage(this.getView(), "src_bidchange", null, BillOperationStatus.EDIT, ShowType.MainNewTabPage, params, null);
                    break;
                }
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u5bfb\u6e90\u9879\u76ee\u5df2\u6709\u672a\u5904\u7406\u7684\u53d8\u66f4\u5355,\u8bf7\u5148\u5904\u7406\u3002", (String)"SrcProjectList_0", (String)"scm-src-formplugin", (Object[])new Object[0]));
                return;
            }
            case "changequery": {
                HashMap<String, Long> paraMap = new HashMap<String, Long>(1);
                paraMap.put("projectid", projectId);
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_changequery", (ShowType)ShowType.Modal, paraMap, null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (BAR_DELETE.equals(key)) {
            Object[] objects;
            BillList list = (BillList)this.getView().getControl("billlistap");
            for (Object id : objects = list.getSelectedRows().getPrimaryKeyValues()) {
                DynamicObject projectCol = BusinessDataServiceHelper.loadSingle((Object)id, (String)"src_project");
                String billstatus = projectCol.getString("billstatus");
                if (!SrcProjectEnum.AUDIT.getCode().equals(billstatus) && !SrcProjectEnum.SUBMIT.getCode().equals(billstatus)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u5355\u636e\u5141\u8bb8\u5220\u9664\u3002", (String)"SrcProjectList_1", (String)"scm-src-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private static void openBillPage(IFormView currView, String pageKey, Object billId, BillOperationStatus openStatus, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(pageKey);
        bsp.setPkId(billId);
        bsp.setBillStatus(openStatus);
        bsp.getOpenStyle().setShowType(showType);
        if (paramMap != null) {
            bsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            bsp.setCloseCallBack(closeCallBack);
        }
        currView.showForm((FormShowParameter)bsp);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        PdsHyperLinkUtils.listOpenFormByBillId((IFormView)this.getView(), (HyperLinkClickArgs)args, (String)"source_billno", (String)"source", (String)"src_demand");
    }
}

