/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.negotiate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.formplugin.negotiate.ISrcNegotiateAddNegBill;
import kd.scm.src.formplugin.negotiate.ISrcNegotiateInit;
import kd.scm.src.formplugin.negotiate.ISrcNegotiatePreSave;
import kd.scm.src.formplugin.negotiate.ISrcNegotiatePrepareData;
import kd.scm.src.formplugin.negotiate.ISrcNegotiateVerify;

public class SrcNegotiateFacade {
    public static void setDefaultValue(IFormView view, String operationKey) {
        ExtPluginContext context = SrcNegotiateFacade.createContext(view, operationKey);
        ExtPluginFactory.executeExtplugin((String)ISrcNegotiateInit.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }

    public static ExtPluginContext prepareData(IFormView view, String operationKey) {
        ExtPluginContext context = SrcNegotiateFacade.createContext(view, operationKey);
        ExtPluginFactory.executeExtplugin((String)ISrcNegotiatePrepareData.class.getSimpleName(), (ExtPluginContext)context, (boolean)false);
        return context;
    }

    public static ExtPluginContext addNegBillVerify(IFormView view, String operationKey) {
        ExtPluginContext context = SrcNegotiateFacade.createContext(view, operationKey);
        ExtPluginFactory.executeExtplugin((String)ISrcNegotiateVerify.class.getSimpleName(), (ExtPluginContext)context, (boolean)false);
        return context;
    }

    public static ExtPluginContext addNegBill(IFormView view, String operationKey) {
        ExtPluginContext context = SrcNegotiateFacade.createContext(view, operationKey);
        ExtPluginFactory.executeExtplugin((String)ISrcNegotiateAddNegBill.class.getSimpleName(), (ExtPluginContext)context, (boolean)false);
        return context;
    }

    public static ExtPluginContext beforeSaveHandle(IFormView view, String operationKey) {
        ExtPluginContext context = SrcNegotiateFacade.createContext(view, operationKey);
        ExtPluginFactory.executeExtplugin((String)ISrcNegotiatePreSave.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
        return context;
    }

    private static ExtPluginContext createContext(IFormView view, String operationKey) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        context.setOperationKey(operationKey);
        context.setBillObj(view.getParentView().getModel().getDataEntity());
        long projectId = 0L;
        if (PdsCommonUtils.isNotProjectBill((String)context.getView().getParentView().getEntityId())) {
            projectId = view.getParentView().getModel().getDataEntity().getLong("project.id");
            context.setProjectObj(view.getParentView().getModel().getDataEntity().getDynamicObject("project"));
        } else {
            projectId = view.getParentView().getModel().getDataEntity().getLong("id");
            context.setProjectObj(view.getParentView().getModel().getDataEntity());
        }
        context.setProjectId(projectId);
        long billId = context.getView().getModel().getDataEntity().getLong("parentid");
        context.setBillId(billId);
        return context;
    }

    public static QFilter getNegExtFilter(long projectId) {
        QFilter qfilters = new QFilter("id", "=", (Object)projectId);
        qfilters.and("extfilter", ">", (Object)0);
        DynamicObject cfgObj = QueryServiceHelper.queryOne((String)"src_compare_config", (String)"extfilter.number", (QFilter[])qfilters.toArray());
        String filterNumber = null;
        filterNumber = null != cfgObj ? PdsCommonUtils.object2String((Object)cfgObj.get("extfilter.number"), (String)"negotiate001") : "negotiate001";
        HashMap<String, Long> paramMap = new HashMap<String, Long>(4);
        paramMap.put("projectid", projectId);
        QFilter qfilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)filterNumber, null, paramMap);
        if (null != qfilter) {
            qfilter.and("project", "=", (Object)projectId);
        }
        return qfilter;
    }

    public static Set<Long> getNegExtFilterPurlistIds(QFilter qfilter) {
        if (null == qfilter) {
            return Collections.emptySet();
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"id", (QFilter[])qfilter.toArray());
        if (rows.size() == 0) {
            return Collections.emptySet();
        }
        return rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }
}

