/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.task.IPdsAutoTaskExecutor;
import kd.scm.pds.common.task.PdsAutoTaskContext;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.util.SrcProjectLockUtil;
import kd.scm.src.common.vie.SrcVieFacade;
import kd.scm.src.common.vie.SrcVieFactory;
import kd.scm.src.formplugin.vie.SrcVieUtils;

public class SrcVieAutoStartService
implements IPdsAutoTaskExecutor {
    private static final long serialVersionUID = 1L;

    public synchronized void execute(PdsAutoTaskContext taskContext) {
        QFilter qfilters = this.buildQFilter();
        DynamicObjectCollection billObjs = QueryServiceHelper.query((String)"src_competebill", (String)"id,opendate", (QFilter[])qfilters.toArray());
        if (billObjs == null || billObjs.size() == 0) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u81ea\u52a8\u542f\u52a8\u7ade\u4ef7\uff1a\u6ca1\u6709\u7b26\u5408\u81ea\u52a8\u542f\u52a8\u7ade\u4ef7\u7684\u9879\u76ee\uff0c\u67e5\u8be2\u6761\u4ef6\u201c%2$s\u201d\u3002", (String)"SrcVieAutoStartService_0", (String)"scm-src-formplugin", (Object[])new Object[0]), this.getClass(), qfilters.toString()));
            return;
        }
        ArrayList<DynamicObject> competeBillObjs = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> quoteBillObjs = new ArrayList<DynamicObject>(8);
        for (DynamicObject billObj : billObjs) {
            String result = SrcVieUtils.verifyBidStart(billObj.getLong("id"));
            if (!"succed".equals(result)) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u81ea\u52a8\u542f\u52a8\u7ade\u4ef7\uff1a\u81ea\u52a8\u542f\u52a8\u7ade\u4ef7\u6821\u9a8c\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\u4e3a\u201c%2$s\u201d\u3002", (String)"SrcVieAutoStartService_1", (String)"scm-src-formplugin", (Object[])new Object[0]), this.getClass(), result));
                continue;
            }
            String lockKey = SrcProjectLockUtil.getAutoTaskLockKey((String)"vieAutoStartLock", (Long)billObj.getLong("id"));
            if (!SrcProjectLockUtil.tryLockProject((String)lockKey)) continue;
            PdsVieContext context = SrcVieFactory.getSrcVieInitContext().createVieContext(billObj.getLong("id"));
            billObj.set("opendate", (Object)TimeServiceHelper.now());
            this.autoStartHandle(competeBillObjs, quoteBillObjs, billObj);
            this.startCDByTimeOutDaemon(context);
        }
        SaveServiceHelper.save((DynamicObject[])competeBillObjs.toArray(new DynamicObject[competeBillObjs.size()]));
        SaveServiceHelper.save((DynamicObject[])quoteBillObjs.toArray(new DynamicObject[quoteBillObjs.size()]));
    }

    private QFilter buildQFilter() {
        Date currentDate = TimeServiceHelper.now();
        QFilter qfilters = ExtFilterUtils.getStringFilter((String)"bidstatus", (String)BidStatusEnum.BEENEXAMINED.getVal());
        Date dateFrom = SrcDateUtils.addDateBySeconds((Date)currentDate, (int)-300);
        qfilters.and("opendate", ">=", (Object)dateFrom);
        Date dateTo = SrcDateUtils.addDateBySeconds((Date)currentDate, (int)300);
        qfilters.and("opendate", "<=", (Object)dateTo);
        qfilters.and("autoconfirm", "=", (Object)"1");
        qfilters.and("currentnode.number", "=", (Object)PdsBizNodeEnums.COMPETE.getValue());
        return qfilters;
    }

    private void autoStartHandle(List<DynamicObject> competeBillObjs, List<DynamicObject> quoteBillObjs, DynamicObject billObj) {
        long projectId = billObj.getLong("id");
        DynamicObject competebillObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_competebill");
        DynamicObject turnsObj = PdsVieHelper.getLastVieTurnsObj((DynamicObject)competebillObj, null);
        SrcVieFacade.setCompeteBillStatus((DynamicObject)billObj, (DynamicObject)competebillObj, (DynamicObject)turnsObj, competeBillObjs);
        SrcVieFacade.setQuoteBillStatus((long)projectId, (String)(turnsObj == null ? "1" : turnsObj.getString("turns")), (String)(turnsObj == null ? "1" : turnsObj.getString("vieturns")), quoteBillObjs);
    }

    private void startCDByTimeOutDaemon(PdsVieContext context) {
        ThreadPools.executeOnce((String)"Http-request-pool-SrcVieOnlinePlugin-countdown", () -> SrcVieFactory.getSrcVieCDByTimeOutDaemon().process(context));
    }
}

