/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.formplugin.vie;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsFlowConfigUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.vie.SrcVieFacade;
import kd.scm.src.common.vie.SrcVieFactory;

public class SrcVieOnlinePlugin
extends AbstractFormPlugin
implements CountDownListener {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        CountDown autorefreshCD;
        super.registerListener(e);
        CountDown countdown = (CountDown)this.getControl("countdownap");
        if (countdown != null) {
            countdown.addCountDownListener((CountDownListener)this);
        }
        if ((autorefreshCD = (CountDown)this.getControl("autorefresh_cd")) != null) {
            autorefreshCD.addCountDownListener((CountDownListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String projectId = PdsCommonUtils.object2String((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"srcbillid"), (String)"");
        String vieturns = PdsCommonUtils.object2String((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"vieturns"), (String)"");
        PdsObjectPools.putInstance((String)PdsCommonUtils.getPageIdKey((IFormView)this.getView().getParentView(), (String)"src_compete", (String)(projectId + '_' + vieturns)), (Object)this.getView().getPageId());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initializeData();
        PdsVieHelper.setAutoRefreshTimes((IFormView)this.getView(), (int)this.getModel().getDataEntity().getInt("srcrefreshtimes"));
        ThreadPools.executeOnce((String)"Http-request-pool-SrcVieOnlinePlugin-countdown", () -> SrcVieFactory.getSrcVieCDByTimeOutDaemon().process(SrcVieFactory.createVieContext((IFormView)this.getView())));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long projectId = this.getModel().getDataEntity().getLong("viebill.id");
        QFilter qFilter = new QFilter("id", "=", (Object)projectId);
        qFilter.and("billstatus", "=", (Object)SrcProjectEnum.AUDIT.getCode());
        if (QueryServiceHelper.exists((String)"src_compete", (QFilter[])qFilter.toArray())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nextstep"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nextstep"});
        }
    }

    protected void initializeData() {
        this.setVieBillId();
        PdsVieHelper.setVieParameter((IFormView)this.getView());
        this.refreshData();
    }

    protected void setVieBillId() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long vieBillId = PdsCommonUtils.object2Long(params.get("billid"));
        this.getView().getModel().setValue("viebill", (Object)vieBillId);
    }

    public void onCountDownEnd(CountDownEvent countDownEvt) {
        CountDown countDown = (CountDown)countDownEvt.getSource();
        switch (countDown.getKey()) {
            case "autorefresh_cd": {
                SrcVieFacade.refreshByCountDown((IFormView)this.getView());
                break;
            }
            case "countdownap": {
                SrcVieFacade.refreshByTimeOut((IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "bidstart": {
                this.vieRestart();
                break;
            }
            case "dealexception": {
                this.dealException();
                break;
            }
            case "analyse": {
                this.analyseQuote();
                break;
            }
            case "attachment": {
                Map paraMap = this.getView().getFormShowParameter().getCustomParams();
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_vie_attachment", (ShowType)ShowType.Modal, (Map)paraMap, null);
                break;
            }
            case "nextstep": {
                this.nextStep();
                break;
            }
            case "refresh": {
                this.refreshData();
                break;
            }
            case "close": {
                this.getView().close();
                break;
            }
            case "logquery": {
                this.bizLogQuery();
                break;
            }
            case "onlinequery": {
                this.onlineQuery();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        PdsCommonUtils.refreshParentView((IFormView)this.getView());
    }

    protected void dealException() {
        PdsVieContext context = SrcVieFactory.createVieContext((IFormView)this.getView());
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        Map paramMap = parameter.getCustomParams();
        paramMap.put("turns", context.getTurns());
        paramMap.put("vieturns", context.getVieturns());
        paramMap.put("bidtime", context.getBidtimes());
        OpenFormUtils.openDynamicPage((IFormView)view, (String)"src_vie_exception", (ShowType)ShowType.Modal, (Map)paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "dealexception"));
    }

    protected void vieRestart() {
        PdsVieContext context = SrcVieFactory.createVieContext((IFormView)this.getView());
        context.setHandleType("E");
        context.setSucced(Boolean.TRUE.booleanValue());
        SrcVieFacade.vieHandle((PdsVieContext)context);
        if (!StringUtils.isBlank((CharSequence)context.getMessage())) {
            this.getView().showMessage(context.getMessage());
        }
        if (context.isSucced()) {
            this.refreshData();
        }
    }

    protected void analyseQuote() {
        PdsVieContext context = SrcVieFactory.createVieContext((IFormView)this.getView());
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_vieanalyze", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qfilter, null);
    }

    protected void nextStep() {
        PdsVieContext context = SrcVieFactory.createVieContext((IFormView)this.getView());
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)context.getVieBillObj().getPkValue(), (String)"src_project");
        if (PdsFlowConfigUtils.existsSpecificNode((DynamicObject)obj, (String)PdsBizNodeEnums.COMPARE.getValue())) {
            OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_compare", (Object)context.getProjectId(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
        } else {
            OpenFormUtils.openBillPage((IFormView)this.getView(), (String)"src_decision", (Object)context.getProjectId(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, null, null);
        }
    }

    protected void refreshData() {
        PdsVieContext context = SrcVieFactory.createVieContext((IFormView)this.getView());
        PdsVieHelper.allowInitializeRedisCache((PdsVieContext)context, (String)"1");
        PdsVieHelper.allowRefreshRedisCache((PdsVieContext)context, (String)"1");
        SrcVieFacade.initVieStatic((PdsVieContext)context);
        SrcVieFacade.initVieDynamic((PdsVieContext)context);
        SrcVieFacade.refreshRank((PdsVieContext)context);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getActionId().equals("dealexception")) {
            this.refreshData();
        }
    }

    public void bizLogQuery() {
        PdsVieContext context = SrcVieFactory.createVieContext((IFormView)this.getView());
        QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
        qFilter.and("entitykey", "=", (Object)"src_competebill");
        qFilter.and("turns", "=", (Object)context.getTurns());
        OpenFormUtils.openListPage((IFormView)this.getView(), (String)"src_bizoperatelog", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
    }

    public void onlineQuery() {
        PdsVieContext context = SrcVieFactory.createVieContext((IFormView)this.getView());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("project", context.getProjectId());
        paramMap.put("turns", context.getTurns());
        paramMap.put("vieturns", context.getVieturns());
        OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"src_viesupplier", (ShowType)ShowType.Modal, paramMap, null);
    }
}

