/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.DataChangeResult;
import kd.scm.pds.common.change.DataHandleFactory;
import kd.scm.pds.common.change.DataValidateFactory;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.change.SrcDataChangeBuilder;
import kd.scm.src.common.change.SrcDataHandleFactory;
import kd.scm.src.common.change.SrcDataValidateFactory;

public class SrcBidChangeAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs evt) {
        super.beforeExecuteOperationTransaction(evt);
        List dataEntity = evt.getValidExtDataEntities();
        for (ExtendedDataEntity extDataEntity : dataEntity) {
            DynamicObject billObj = extDataEntity.getDataEntity();
            this.doAudit(billObj, evt);
        }
    }

    protected void doAudit(DynamicObject billObj, BeforeOperationArgs evt) {
        long bidChangeId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        DynamicObject bidChangeObj = BusinessDataServiceHelper.loadSingle((Object)bidChangeId, (String)"src_bidchange");
        SrcDataValidateFactory validateFactory = new SrcDataValidateFactory(bidChangeObj);
        Map<String, Object> compKey_objMap = this.getCompKeyDataMap(bidChangeObj);
        compKey_objMap.put("opkey", evt.getOperationKey());
        validateFactory.getValidateEvent().setParams(compKey_objMap);
        SrcDataHandleFactory handleFactory = new SrcDataHandleFactory(bidChangeObj);
        handleFactory.getHandleEvent().setParams(compKey_objMap);
        SrcDataChangeBuilder dataBuilder = new SrcDataChangeBuilder((DataValidateFactory)validateFactory, (DataHandleFactory)handleFactory);
        DataChangeResult result = dataBuilder.execute();
        if (result.isSuccess()) {
            this.afterHandle(handleFactory.getHandleEvent());
            this.handLog(result.getHandleResult(), bidChangeObj);
        } else {
            evt.setCancelMessage(result.getMessage());
            evt.setCancel(true);
        }
    }

    protected Map<String, Object> getCompKeyDataMap(DynamicObject bidChangeObj) {
        HashMap<String, Object> compKey_objMap = new HashMap<String, Object>(8);
        List compKeyList = TemplateUtil.getCompKeyList((DynamicObject)bidChangeObj);
        for (String compKey : compKeyList) {
            DynamicObject compObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)compKey);
            compKey_objMap.put(compKey, compObj);
        }
        return compKey_objMap;
    }

    protected void handLog(HandleResult result, DynamicObject bidChangeObj) {
        List handLogList = result.getHandLogList();
        DynamicObjectCollection logEntry = bidChangeObj.getDynamicObjectCollection("logentry");
        logEntry.clear();
        for (String handLog : handLogList) {
            if (StringUtils.isBlank((String)handLog) || StringUtils.isNull((String)handLog)) continue;
            if (handLog.length() > 500) {
                handLog = handLog.substring(0, 500);
            }
            DynamicObject newEntry = logEntry.addNew();
            newEntry.set("chgcontent", (Object)handLog);
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)bidChangeObj, (String)"logentry");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidChangeObj});
    }

    protected void afterHandle(HandleEvent handleEvent) {
        DynamicObject bidChangeObj = handleEvent.getObj();
        StringBuilder number = new StringBuilder(IDataHandleService.class.getSimpleName()).append('_');
        number.append(bidChangeObj.getString("template.number"));
        List hadlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(number.toString(), null);
        if (null == hadlers || hadlers.size() == 0) {
            return;
        }
        for (IDataHandleService hadler : hadlers) {
            hadler.handle(handleEvent);
        }
    }
}

