/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SrcProjectNodeNameUpgradePlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SrcProjectNodeNameUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5bfb\u6e90\u7ba1\u7406-\u9879\u76ee\u542f\u52a8-\u5bfb\u6e90\u9879\u76ee\u8282\u70b9\u540d\u79f0\u65e7\u6570\u636e\u5347\u7ea7\u3002", (String)"SrcProjectNodeNameUpgradePlugin_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            boolean upgradeResult = this.upgrade(pProcessInfo, dbKey);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog(pProcessInfo.append(ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"SrcProjectNodeNameUpgradePlugin_1", (String)"scm-src-opplugin", (Object[])new Object[0])).toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            String errorInfo = ResManager.loadKDString((String)"\u65e7\u6570\u636e\u5347\u7ea7\u6267\u884c\u5f02\u5e38\u3002", (String)"SrcProjectNodeNameUpgradePlugin_2", (String)"scm-src-opplugin", (Object[])new Object[0]);
            logger.error(errorInfo, (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    private boolean upgrade(StringBuilder pProcessInfo, String dbKey) {
        int pageSize = 200;
        DBRoute dbRoute = new DBRoute("pur");
        Map<String, String> nodeIdNameMap = this.getBizNodeMap(dbRoute);
        String sqlAll = "select fid from T_SRC_PROJECT where fnodename=' ' and fcurrentnode<>0";
        try (DataSet dataSet1 = DB.queryDataSet((String)"SrcProjectNodeNameUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sqlAll, null);){
            ArrayList idList = new ArrayList();
            dataSet1.forEach(row -> idList.add(row.getLong("fid")));
            pProcessInfo.append(ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf", (String)"SrcProjectNodeNameUpgradePlugin_3", (String)"scm-src-opplugin", (Object[])new Object[0])).append(idList.size()).append("\n");
            int count = idList.size();
            int totalPages = count / pageSize;
            if (count % pageSize != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List subIdList = (pageIndex + 1) * pageSize > idList.size() ? idList.subList(pageIndex * pageSize, idList.size()) : idList.subList(pageIndex * pageSize, (pageIndex + 1) * pageSize);
                if (subIdList.isEmpty()) continue;
                String ids = String.join((CharSequence)",", (CharSequence[])subIdList.stream().map(String::valueOf).toArray(String[]::new));
                String sql = "select fid,fnodename,fcurrentnode from T_SRC_PROJECT  where fid in (" + ids + ") ";
                Map<Object, Object> sqlParms = this.callNodeNameUpgradePlugin(dbRoute, sql, nodeIdNameMap);
                dbRoute = new DBRoute(dbKey);
                ArrayList<Object[]> parms = new ArrayList<Object[]>(sqlParms.size());
                for (Map.Entry<Object, Object> entry : sqlParms.entrySet()) {
                    Object[] parm = new Object[]{entry.getValue(), entry.getKey()};
                    parms.add(parm);
                }
                if (parms.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                this.updateData(dbRoute, parms);
            }
        }
        return true;
    }

    private Map<Object, Object> callNodeNameUpgradePlugin(DBRoute dbRoute, String sql, Map<String, String> idNameMap) {
        HashMap<Object, Object> sqlParms = new HashMap<Object, Object>();
        try (DataSet dataSet = DB.queryDataSet((String)"SrcProjectNodeNameUpgradePlugin.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    long currtnode = row.getLong("fcurrentnode");
                    if (currtnode <= 0L) continue;
                    String nodeName = idNameMap.get(String.valueOf(currtnode));
                    sqlParms.put(row.getLong("fid"), nodeName);
                }
            }
        }
        return sqlParms;
    }

    private Map<String, String> getBizNodeMap(DBRoute dbRoute) {
        HashMap<String, String> idNameMap = new HashMap<String, String>(128);
        String sqlAll = "select fid,fname from T_pds_biznode_l where flocaleid='zh_CN'";
        try (DataSet dataSet1 = DB.queryDataSet((String)"SrcProjectNodeNameUpgradePlugin.querybiznode", (DBRoute)dbRoute, (String)sqlAll, null);){
            dataSet1.forEach(row -> idNameMap.put(String.valueOf(row.getLong("fid")), row.getString("fname")));
        }
        return idNameMap;
    }

    private void updateData(DBRoute dbRoute, List<Object[]> parms) {
        DB.executeBatch((DBRoute)dbRoute, (String)"update T_SRC_PROJECT set fnodename = ? where fid = ?", parms);
    }
}

