/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.src.common.enums.SrcSourceStateEnum;
import kd.scm.src.common.util.SrcBidCompTplUtil;

public class SrcProjectOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("source");
        fields.add("amount");
        fields.add("sourcestate");
        fields.add("sourcestateprint");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        OperationResult operationResult = this.getOperationResult();
        switch (operationKey) {
            case "submit": {
                DynamicObject[] dataEntities;
                if (!operationResult.isSuccess()) break;
                for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
                    DynamicObjectCollection entryNodeCols = dynamicObject.getDynamicObjectCollection("entrymainflow");
                    int entryNodeSize = entryNodeCols.size();
                    if (entryNodeSize == 0) continue;
                    DynamicObject entryNodeCol = (DynamicObject)entryNodeCols.get(0);
                    DynamicObjectCollection subEntryCols = entryNodeCol.getDynamicObjectCollection("entrysubflow");
                    int subEntrySize = subEntryCols.size();
                    for (int j = 0; j < subEntrySize; ++j) {
                        DynamicObject subEntryCol = (DynamicObject)subEntryCols.get(j);
                        SrcBidCompTplUtil.createOrUpdateExtObjEntry((DynamicObject)dynamicObject, (DynamicObject)subEntryCol, (int)0);
                    }
                    DynamicObject sourceId = dynamicObject.getDynamicObject("source");
                    if (null == sourceId) {
                        return;
                    }
                    String sourceState = dynamicObject.getString("sourcestate");
                    if (!StringUtils.isNotEmpty((String)sourceState)) continue;
                    String[] arr = sourceState.split(",");
                    String sourceStatePrint = Arrays.stream(arr).filter(str -> StringUtils.isNotEmpty((String)str)).map(code -> SrcSourceStateEnum.fromCode((String)code).getContent()).collect(Collectors.joining(","));
                    dynamicObject.set("sourcestateprint", (Object)sourceStatePrint);
                }
                SaveServiceHelper.save((DynamicObject[])dataEntities);
                break;
            }
        }
    }
}

