/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcBidCompTplUtil;

public class SrcProjectPurlistAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("id");
        fields.add("billstatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] purlistObjs = this.getPurlistObjs(args);
        if (null == purlistObjs || purlistObjs.length == 0) {
            return;
        }
        ArrayList<Long> pkIdList = new ArrayList<Long>(purlistObjs.length);
        ArrayList<DynamicObject> purlistObjList = new ArrayList<DynamicObject>(purlistObjs.length);
        for (DynamicObject purlistObj : purlistObjs) {
            boolean isNeedAduit = SrcBidCompTplUtil.isNeedAudit((DynamicObject)purlistObj);
            if (isNeedAduit) continue;
            pkIdList.add(purlistObj.getLong("id"));
            boolean isChanged1 = this.setDefaultValue(purlistObj);
            boolean isChanged2 = this.addPurListCompToTplentry(purlistObj);
            if (!isChanged1 && !isChanged2) continue;
            purlistObjList.add(purlistObj);
        }
        if (pkIdList.size() == 0) {
            return;
        }
        if (purlistObjList.size() > 0) {
            PdsCommonUtils.saveDynamicObjects(purlistObjList);
        }
        this.doSubmitThenAudit(pkIdList);
    }

    private void doSubmitThenAudit(List<Long> pkIdList) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isStrict", String.valueOf(false));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        OperationResult submitRet = OperationServiceHelper.executeOperate((String)"submit", (String)"src_purlist", (Object[])pkIdList.toArray(new Long[0]), (OperateOption)operateOption);
        if (!submitRet.isSuccess()) {
            throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)submitRet.getAllErrorOrValidateInfo()));
        }
        OperationResult auditRet = OperationServiceHelper.executeOperate((String)"audit", (String)"src_purlist", (Object[])pkIdList.toArray(new Long[0]), (OperateOption)operateOption);
        if (!auditRet.isSuccess()) {
            throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)auditRet.getAllErrorOrValidateInfo()));
        }
    }

    private DynamicObject[] getPurlistObjs(BeginOperationTransactionArgs args) {
        DynamicObject[] billObjs = args.getDataEntities();
        List projectIds = Arrays.asList(billObjs).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        QFilter qfilter = new QFilter("id", "in", projectIds);
        qfilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getVal());
        String selectFields = "id,org,tenderside,creator,createtime,template,tplentry,tplentry.seq,tplentry.tmp_template,tplentry.tmp_component,tplentry.tmp_bizobject,tplentry.srctplid,entrymainflow.biznode,entrymainflow.bizobject,entrysubflow.subbiznode,entrysubflow.subbizobject,entrysubflow.subisaudit";
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlist", (String)selectFields, (QFilter[])qfilter.toArray());
        if (null == purlistObjs || purlistObjs.length == 0) {
            return null;
        }
        return purlistObjs;
    }

    private boolean setDefaultValue(DynamicObject billObj) {
        boolean isChanged = false;
        if (billObj.get("tenderside") == null) {
            billObj.set("tenderside", (Object)billObj.getLong("org.id"));
            isChanged = true;
        }
        if (billObj.get("creator") == null) {
            billObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            billObj.set("createtime", (Object)TimeServiceHelper.now());
            isChanged = true;
        }
        return isChanged;
    }

    private boolean addPurListCompToTplentry(DynamicObject billObj) {
        boolean isChanged1 = this.createPurListTplEntryData("isattachpurlist", true, billObj);
        boolean isChanged2 = this.createPurListTplEntryData("isaddpurlist", true, billObj);
        return isChanged1 || isChanged2;
    }

    private boolean createPurListTplEntryData(String pro, boolean isAttach, DynamicObject billObj) {
        List<DynamicObject> currCompEntryList = this.getCurrTplCompEntry(billObj);
        if (currCompEntryList.size() == 0) {
            return false;
        }
        Map<String, DynamicObject> purListTplMap = this.getPurListTplByPro(pro, billObj);
        if (purListTplMap.size() == 0) {
            return false;
        }
        Map<String, Object> entryGroupKeyMap = this.getTplEntryGroupKey(pro, isAttach, billObj);
        DynamicObjectCollection tplEntrys = billObj.getDynamicObjectCollection("tplentry");
        int i = 0;
        for (Map.Entry<String, DynamicObject> tplEntry : purListTplMap.entrySet()) {
            for (DynamicObject compObjEntry : currCompEntryList) {
                DynamicObject component;
                DynamicObject tplEntryObj = tplEntrys.addNew();
                StringBuilder groupKeySb = new StringBuilder();
                groupKeySb.append(tplEntry.getKey());
                tplEntryObj.set("tmp_template", (Object)tplEntry.getKey());
                String bizObj = compObjEntry.getString("tmp_bizobject");
                if (null != bizObj) {
                    tplEntryObj.set("tmp_bizobject", (Object)bizObj);
                }
                if (null != (component = compObjEntry.getDynamicObject("tmp_component"))) {
                    groupKeySb.append('_').append(component.getPkValue());
                    tplEntryObj.set("tmp_component", component.getPkValue());
                }
                DynamicObject entryTpl = compObjEntry.getDynamicObject("tmp_template");
                if (isAttach && null != entryTpl) {
                    groupKeySb.append('_').append(entryTpl.getPkValue());
                    tplEntryObj.set("srctplid", entryTpl.getPkValue());
                }
                if (null != entryGroupKeyMap.get(groupKeySb.toString())) continue;
                ++i;
            }
        }
        if (i > 0) {
            DynamicObjectUtil.setBillEntrySeq((DynamicObject)billObj, (String)"tplentry");
            return true;
        }
        return false;
    }

    private List<DynamicObject> getCurrTplCompEntry(DynamicObject billObj) {
        ArrayList<DynamicObject> currCompList = new ArrayList<DynamicObject>();
        Object template = billObj.get("template");
        if (null == template) {
            return currCompList;
        }
        DynamicObject templateDy = (DynamicObject)template;
        DynamicObjectCollection compEntryCols = billObj.getDynamicObjectCollection("tplentry");
        for (DynamicObject entryCol : compEntryCols) {
            DynamicObject tplEntryTemplate;
            Object templateObj = entryCol.get("tmp_template");
            if (!(templateObj instanceof DynamicObject) || null == (tplEntryTemplate = entryCol.getDynamicObject("tmp_template")) || !tplEntryTemplate.getPkValue().toString().equals(templateDy.getPkValue().toString())) continue;
            currCompList.add(entryCol);
        }
        return currCompList;
    }

    private Map<String, DynamicObject> getPurListTplByPro(String pro, DynamicObject billObj) {
        HashMap<String, DynamicObject> isAttachPurListTplMap = new HashMap<String, DynamicObject>(8);
        DynamicObjectCollection compEntryCols = billObj.getDynamicObjectCollection("tplentry");
        for (DynamicObject entryCol : compEntryCols) {
            DynamicObject tplEntryTemplate;
            Object templateObj = entryCol.get("tmp_template");
            if (!(templateObj instanceof DynamicObject) || null != isAttachPurListTplMap.get((tplEntryTemplate = entryCol.getDynamicObject("tmp_template")).getPkValue().toString()) || !tplEntryTemplate.getBoolean(pro)) continue;
            isAttachPurListTplMap.put(tplEntryTemplate.getPkValue().toString(), tplEntryTemplate);
        }
        return isAttachPurListTplMap;
    }

    private Map<String, Object> getTplEntryGroupKey(String pro, boolean isAttach, DynamicObject billObj) {
        HashMap<String, Object> entryGroupKeyMap = new HashMap<String, Object>();
        DynamicObjectCollection compEntryCols = billObj.getDynamicObjectCollection("tplentry");
        for (DynamicObject entryCol : compEntryCols) {
            DynamicObject tplEntryTemplate;
            StringBuilder groupKeySb = new StringBuilder();
            Object templateObj = entryCol.get("tmp_template");
            if (!(templateObj instanceof DynamicObject) || !(tplEntryTemplate = entryCol.getDynamicObject("tmp_template")).getBoolean(pro)) continue;
            groupKeySb.append(tplEntryTemplate.getPkValue());
            DynamicObject component = entryCol.getDynamicObject("tmp_component");
            if (null != component) {
                groupKeySb.append('_').append(component.getPkValue());
            }
            if (!isAttach) continue;
            groupKeySb.append('_').append(entryCol.getString("srctplid"));
            entryGroupKeyMap.putIfAbsent(groupKeySb.toString(), groupKeySb.toString());
        }
        return entryGroupKeyMap;
    }
}

