/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.BizLog;
import kd.bos.openapi.api.result.ApiSaveItemData;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenApiSdkUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.CodeRuleUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.RandomUtils;
import kd.scm.src.opplugin.action.SrcPurDataHandleAction;

public class SrcTempUserCreateBdUserAction
extends SrcPurDataHandleAction {
    public void doExecute() {
        String apiUrl = "/v2/base/bos_user/update";
        HashMap<String, Map<String, Object>> requestData = new HashMap<String, Map<String, Object>>(2);
        DynamicObject billObj = this.getSourceData();
        requestData.put("data", this.getUserDataMap(billObj));
        OpenApiResult result = OpenApiSdkUtil.invoke((String)apiUrl, requestData);
        if (null != result) {
            this.resultMap.put("succed", Boolean.TRUE);
            this.resultMap.put("message", "");
            Object resultData = result.getData();
            if (resultData instanceof ApiSaveResult) {
                ApiSaveResult apiSaveResult = (ApiSaveResult)resultData;
                if (!result.isStatus()) {
                    List apiSaveItemDataList = apiSaveResult.getResult();
                    ArrayList errorMessages = new ArrayList();
                    apiSaveItemDataList.forEach(apiSaveItemData -> {
                        List errors = apiSaveItemData.getErrors();
                        errors.forEach(apiSaveRowErrorData -> {
                            Set rowMsg = apiSaveRowErrorData.getRowMsg();
                            errorMessages.addAll(rowMsg);
                        });
                    });
                    this.resultMap.put("succed", Boolean.FALSE);
                    this.resultMap.put("message", errorMessages.stream().collect(Collectors.joining("\n")));
                    this.throwException();
                } else {
                    String userIdStr = ((ApiSaveItemData)apiSaveResult.getResult().get(0)).getId();
                    Long userId = Long.valueOf(userIdStr);
                    BizLog.log((String)("create bos_user id:" + userId));
                    billObj.set("user", (Object)userId);
                    this.updateUserPicture(userId, billObj);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billObj});
                }
            }
        }
    }

    private void updateUserPicture(Long userId, DynamicObject billObj) {
        String picture = billObj.getString("picture");
        if (StringUtils.isNotEmpty((String)picture)) {
            DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
            userObj.set("picturefield", (Object)picture);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userObj});
        }
    }

    private Map<String, Object> getUserDataMap(DynamicObject billObj) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("id", 0L);
        dataMap.put("name", billObj.getString("name"));
        dataMap.put("gender", billObj.getString("sex"));
        String number = null;
        try {
            number = CodeRuleUtil.getCodeRule((String)"bos_user");
        }
        catch (Exception e) {
            BizLog.log((String)("get coderule exception:" + e.getMessage()));
            HashSet exsitsSet = new HashSet(1);
            number = RandomUtils.generateRandomCode((int)6, exsitsSet);
        }
        dataMap.put("number", number);
        dataMap.put("username", billObj.getString("name"));
        dataMap.put("phone", billObj.getString("telephone"));
        dataMap.put("email", billObj.getString("email"));
        this.mapData(dataMap, billObj);
        ArrayList userTypesList = new ArrayList(1);
        HashMap<String, Object> userType2Map = new HashMap<String, Object>(2);
        userType2Map.put("id", 1733424029626517504L);
        userType2Map.put("number", "PTSRM01");
        userTypesList.add(userType2Map);
        dataMap.put("usertypes", userTypesList);
        return dataMap;
    }

    public void mapData(Map<String, Object> dataMap, DynamicObject billObj) {
        List<String> mapperStrList = this.matchFields("src_regexpert", "bos_user");
        if (null == mapperStrList) {
            return;
        }
        for (String mapStr : mapperStrList) {
            Object sourceVal;
            String[] mapStrArr;
            if (StringUtils.isBlank((String)mapStr) || (mapStrArr = mapStr.split("\\|")).length != 2) continue;
            Object mapVal = null;
            String sourceField = mapStrArr[0];
            String targetField = mapStrArr[1];
            if (sourceField.split("\\.").length > 1 || null == (sourceVal = billObj.get(sourceField))) continue;
            mapVal = sourceVal instanceof DynamicObject ? Long.valueOf(((DynamicObject)sourceVal).getLong("id")) : sourceVal;
            dataMap.put(targetField, mapVal);
        }
    }

    public List<String> matchFields(String sourceEntityKey, String targetEntityKey) {
        List mapperStrList = PdsCommonUtils.getPropertiesFromFieldMapper2((String)sourceEntityKey, (String)targetEntityKey);
        return mapperStrList;
    }
}

