/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcAptitudeRecommendHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        if (!"1".equals(context.getBillObj().getString("suppliertype"))) {
            return;
        }
        if (this.isSelectSupplierAudited(context)) {
            return;
        }
        DynamicObject[] enrollRows = this.getEnrollRows(context);
        if (null == enrollRows || enrollRows.length == 0) {
            return;
        }
        if (context.getOperationKey().equals("audit")) {
            if (!QueryServiceHelper.exists((String)"src_supplierinvite", (QFilter[])this.getQFilter(context).toArray())) {
                this.createSelectSupplier(enrollRows);
            }
        } else if (context.getOperationKey().equals("unaudit")) {
            this.deleteSelectSupplier(context, enrollRows);
        }
    }

    private DynamicObject[] getEnrollRows(ExtPluginContext context) {
        long projectId = context.getBillObj().getLong("id");
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        Set<Long> supplierIds = this.getSupplierIds(context);
        qfilters.and("supplier", "in", supplierIds);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_enrollsupplier", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_enrollsupplier", (String)selectFields, (QFilter[])qfilters.toArray());
        if (rows.length == 0 || !context.getBillObj().getString("managetype").equals("2")) {
            return rows;
        }
        ArrayList<DynamicObject> enrollSupList = new ArrayList<DynamicObject>(rows.length);
        String supPkgKey = null;
        for (DynamicObject row : rows) {
            supPkgKey = this.getSupPkgKey(row);
            if (!context.getCompKeys().contains(supPkgKey)) continue;
            enrollSupList.add(row);
        }
        return enrollSupList.toArray(new DynamicObject[0]);
    }

    private String getSupPkgKey(DynamicObject row) {
        return String.valueOf(row.getLong("supplier.id")) + '_' + String.valueOf(row.getLong("package.id"));
    }

    private Set<Long> getSupplierIds(ExtPluginContext context) {
        Map paramMap = context.getParamMap();
        HashSet<Long> supplierIds = new HashSet<Long>(paramMap.size());
        HashSet<String> supPkgSet = new HashSet<String>(paramMap.size());
        for (Map.Entry entry : paramMap.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getValue();
            if (!obj.getString("isaptitude").equals("1")) continue;
            supplierIds.add(PdsCommonUtils.object2Long((Object)entry.getKey().toString().split("\\_")[0]));
            supPkgSet.add((String)entry.getKey());
        }
        context.setCompKeys(supPkgSet);
        return supplierIds;
    }

    protected void createSelectSupplier(DynamicObject[] enrollRows) {
        ArrayList<DynamicObject> selectRows = new ArrayList<DynamicObject>(enrollRows.length);
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)enrollRows[0]);
        HashSet excludedFields = new HashSet();
        int seq = 1;
        for (DynamicObject enrollRow : enrollRows) {
            enrollRow.set("isselect", (Object)"1");
            enrollRow.set("note", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u63a8\u8350\u5165\u56f4", (String)"SrcAptitudeRecommendHandler_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            DynamicObject selectRow = BusinessDataServiceHelper.newDynamicObject((String)"src_supplierinvite");
            PdsCommonUtils.setPrimaryKey((DynamicObject)selectRow);
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)enrollRow, (DynamicObject)selectRow, (List)properties, excludedFields, (int)seq++);
            selectRow.set("isinvite", (Object)"1");
            selectRow.set("publishstatus", (Object)"A");
            selectRow.set("entrysupplierip", enrollRow.get("supplierip"));
            selectRow.set("supname", enrollRow.get("supplier.name"));
            selectRows.add(selectRow);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])enrollRows);
        PdsCommonUtils.saveDynamicObjects(selectRows);
    }

    protected void deleteSelectSupplier(ExtPluginContext context, DynamicObject[] enrollRows) {
        for (DynamicObject enrollRow : enrollRows) {
            enrollRow.set("isselect", (Object)"0");
            enrollRow.set("note", null);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])enrollRows);
        DeleteServiceHelper.delete((String)"src_supplierinvite", (QFilter[])this.getQFilter(context).toArray());
    }

    private QFilter getQFilter(ExtPluginContext context) {
        long projectId = context.getBillObj().getLong("id");
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        return qfilters;
    }

    private boolean isSelectSupplierAudited(ExtPluginContext context) {
        long projectId = context.getBillObj().getLong("id");
        QFilter qfilters = new QFilter("id", "=", (Object)projectId);
        qfilters.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal()).or("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        return QueryServiceHelper.exists((String)"src_selectsupplier", (QFilter[])qfilters.toArray());
    }
}

