/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcAutoEndchangeHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext args) {
        if (!this.isNeedChange(args)) {
            return;
        }
        ExtPluginContext context = this.createChangeContext(args);
        DynamicObject changeObj = SrcBidChangeUtil.getBidChangeBill((ExtPluginContext)context);
        if (null == changeObj) {
            changeObj = SrcBidChangeUtil.createBidChangeBill((ExtPluginContext)context);
        }
        PdsCommonUtils.doOperation((DynamicObject)changeObj, (String)"submit");
        PdsCommonUtils.doOperation((DynamicObject)changeObj, (String)"audit");
    }

    public ExtPluginContext createChangeContext(ExtPluginContext args) {
        ExtPluginContext context = new ExtPluginContext();
        context.setProjectObj(args.getBillObj());
        context.setProjectId(args.getProjectId());
        context.setParamMap(args.getParamMap());
        this.initValueMap(context);
        return context;
    }

    public void initValueMap(ExtPluginContext context) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
        valueMap.put("changesource", "3");
        valueMap.put("project", context.getProjectId());
        long templateId = PdsCommonUtils.object2Long(context.getParamMap().get("template"));
        if (templateId == 0L) {
            templateId = PdsCommonUtils.getBasedataIdByNumber((String)"pds_tplconfig", (String)"SYS042");
        }
        valueMap.put("template", templateId);
        DynamicObject changeType = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"pds_tplconfig");
        context.setSourceObj(changeType);
        valueMap.put("remark", ResManager.loadKDString((String)"\u53d1\u5e03\u6d41\u6807\u516c\u544a\u540e\u81ea\u52a8\u7ec8\u6b62\u9879\u76ee\u3002", (String)"SrcAutoEndchangeHandler_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
        valueMap.put("biztype", context.getProjectObj().getLong("biztype.id"));
        valueMap.put("org", context.getProjectObj().getLong("org.id"));
        valueMap.put("currentnode", PdsCommonUtils.getNodeIdByEntityName((String)context.getProjectObj().getDataEntityType().getName()));
        context.getParamMap2().put("src_bidchange", valueMap);
    }

    public boolean isNeedChange(ExtPluginContext args) {
        QFilter qfilter = new QFilter("srcbillid", "=", (Object)args.getProjectId());
        qfilter.and("biztype", "=", (Object)"D");
        qfilter.and("pentitykey", "=", (Object)args.getBillObj().getDataEntityType().getName());
        return QueryServiceHelper.exists((String)"src_decisionnotice", (QFilter[])qfilter.toArray());
    }
}

