/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.audithandle;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.PdsBizNodeEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcProjectUtil;

public class SrcDemandAuditCreatePreProject
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.initContext(context);
        if (!context.isVerifyOk()) {
            return;
        }
        this.createPreProject(context);
        if (!context.isVerifyOk()) {
            return;
        }
        this.setDemandPushStatus(context);
    }

    public void initContext(ExtPluginContext context) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)"src_demand");
        if (billObj.getBoolean("ismultiscene")) {
            context.setVerifyOk(false);
            return;
        }
        long flowId = billObj.getLong("srctype2.id");
        QFilter qfilter = new QFilter("id", "=", (Object)flowId);
        qfilter.and("entrynode.biznode", "=", (Object)PdsBizNodeEnums.PREPROJECT.getId());
        DynamicObject flowObj = QueryServiceHelper.queryOne((String)"pds_flowconfig", (String)"entrynode.template.id", (QFilter[])qfilter.toArray());
        if (null == flowObj) {
            context.setVerifyOk(false);
            return;
        }
        flowObj = BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"pds_flowconfig");
        context.setTargetObj(flowObj);
        context.setBillObj(billObj);
    }

    public void createPreProject(ExtPluginContext context) {
        DynamicObject billObj = context.getBillObj();
        long projectId = SrcProjectUtil.createNewBillId((String)"src_preproject", (String)billObj.getString("sourcetype2.number"), (long)billObj.getLong("srctype2.id"), (boolean)true);
        if (projectId == 0L) {
            context.setVerifyOk(false);
            return;
        }
        context.setProjectId(projectId);
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_preproject");
        if (null == projectObj) {
            context.setVerifyOk(false);
            return;
        }
        projectObj.set("bidname", (Object)billObj.getString("title"));
        projectObj.set("org", (Object)billObj.getLong("org.id"));
        projectObj.set("managetype", (Object)billObj.getString("srctype2.managetype"));
        projectObj.set("sourceclass", (Object)billObj.getLong("srctype2.sourceclass.id"));
        SrcProjectUtil.setBizTypeDefaultValue((DynamicObject)projectObj, (DynamicObject)billObj.getDynamicObject("biztype"));
        long templateId = ((DynamicObject)context.getTargetObj().getDynamicObjectCollection("entrynode").get(0)).getLong("template.id");
        projectObj.set("template", (Object)templateId);
        projectObj.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        projectObj.set("bizstatus", (Object)ProcessStatusEnums.PROCESSING.getValue());
        projectObj.set("currentnode", (Object)PdsBizNodeEnums.PREPROJECT.getId());
        projectObj.set("currentnodename", (Object)projectObj.getString("currentnode.name"));
        projectObj.set("source", (Object)context.getBillId());
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entry");
        if (rows.size() > 0) {
            projectObj.set("scene", ((DynamicObject)rows.get(0)).getPkValue());
        }
        projectObj.set("ispreproject", (Object)"1");
        projectObj.set("createtime", billObj.get("createtime"));
        projectObj.set("creator", billObj.get("creator"));
        SrcProjectUtil.createEntryData((DynamicObject)projectObj);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)projectObj);
        projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_preproject");
        context.setProjectObj(projectObj);
    }

    public void setDemandPushStatus(ExtPluginContext context) {
        DynamicObject billObj = context.getBillObj();
        billObj.set("parentid", (Object)context.getProjectId());
        billObj.set("pentitykey", (Object)"src_preproject");
        billObj.set("entitykey", (Object)"src_demand_comp");
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entry");
        if (rows.size() > 0) {
            ((DynamicObject)rows.get(0)).set("scenestatus", (Object)"B");
            ((DynamicObject)rows.get(0)).set("project", (Object)context.getProjectId());
            ((DynamicObject)rows.get(0)).set("projectno", (Object)context.getProjectObj().getString("billno"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject)billObj);
    }
}

