/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.src.common.srcbotp.SrcBotpContext;
import kd.scm.src.common.srcbotp.SrcBotpUtils;

public class SrcDemandToProjectBOTP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        HashSet fieldSet = new HashSet();
        Collections.addAll(fieldSet, "billstatus", "purdecision", "decision", "sumamount", "sumtaxamount", "entry", "sceneno_des1", "title", "isspecial", "srcemotion", "signingcycle", "region", "chassisttype", "currency", "title", "purorg", "busitype", "busiarea", "place", "servicetype");
        Collections.addAll(fieldSet, "entryentityyear", "entryentity", "category3", "category2", "indicate1", "amount", "biztype");
        e.getFieldKeys().addAll(fieldSet);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        Boolean isdecision = PdsCommonUtils.object2Boolean((Object)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"isdecision"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"src_project");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, (String)null);
        if (null == codeRule) {
            FormMetadata metaData = PdsMetadataUtil.getFormMetaData((String)"src_project");
            String entityName = metaData.getName().toString();
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u8bf7\u542f\u7528%1$s\u7684\u7f16\u7801\u89c4\u5219\uff0c\u5426\u5219\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"SrcDemandToProjectBOTP_1", (String)"scm-src-opplugin", (Object[])new Object[0]), entityName));
            e.setCancel(true);
            return;
        }
        ArrayList<DynamicObject> demandObjs = new ArrayList<DynamicObject>(e.getValidExtDataEntities().size());
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            DynamicObject demandObj = dataEntity.getDataEntity();
            if (!this.isAllowPush(e, demandObj, isdecision)) continue;
            demandObjs.add(demandObj);
        }
        if (demandObjs.size() > 0) {
            InteractionContext interactionContext = new InteractionContext();
            SrcBotpContext context = SrcBotpUtils.getContextInstance();
            String sourceType = this.getOption().getVariableValue("sourcetype", null);
            context.setSourceType(sourceType);
            context.setEntryStatus(ProjectStatusEnums.TOQUOTE.getValue());
            this.createProject(demandObjs, interactionContext, context);
            this.getOperationResult().setInteractionContext(interactionContext);
        }
    }

    private boolean verifyIsDecisionResult(DynamicObject demand, BeforeOperationArgs e) {
        boolean isdecisionresult = demand.getBoolean("purdecision");
        if (!isdecisionresult) {
            return true;
        }
        if ("B".equals(demand.getString("resultstatus")) || "D".equals(demand.getString("resultstatus"))) {
            return true;
        }
        if (demand.getBoolean("istemppush") && !StringUtils.isEmpty((CharSequence)demand.getString("tempreason"))) {
            return true;
        }
        if ("C".equals(demand.getString("resultstatus"))) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u7684\u51b3\u8bae\u72b6\u6001\u4e3a\u4e0d\u901a\u8fc7, \u4e0d\u5141\u8bb8\u4e0b\u63a8\u6b63\u5f0f\u5bfb\u6e90\u3002", (String)"SrcDemandToProjectBOTP_2", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return false;
        }
        e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u7684\u51b3\u8bae\u72b6\u6001\u4e3a\u5f85\u8bc4\u5ba1,\u987b\u8bbe\u7f6e\u4e3a\u4e34\u65f6\u4e0b\u63a8\u5e76\u586b\u5199\u4e34\u65f6\u4e0b\u63a8\u539f\u56e0, \u5426\u5219\u4e0d\u5141\u8bb8\u4e0b\u63a8\u6b63\u5f0f\u5bfb\u6e90\u3002", (String)"SrcDemandToProjectBOTP_3", (String)"scm-src-opplugin", (Object[])new Object[0]));
        return false;
    }

    private boolean isAllowPush(BeforeOperationArgs e, DynamicObject demandObj, Boolean isdecision) {
        String billStatus = demandObj.getString("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)"C")) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6838\uff0c\u65e0\u6cd5\u4e0b\u63a8\u5bfb\u6e90\u7acb\u9879\u5355\u3002", (String)"SrcDemandToProjectBOTP_4", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!isdecision.booleanValue() && !this.verifyIsDecisionResult(demandObj, e)) {
            e.setCancel(true);
            return false;
        }
        return true;
    }

    private void createProject(List<DynamicObject> sourceObjs, InteractionContext interactionContext, SrcBotpContext context) {
        context.setSourceBill("src_demand");
        context.setTargetBill("src_project");
        context.setSourceObjs(sourceObjs);
        context.setBySceneItem(true);
        context.setPurlistSourceBill("src_demandf7two");
        context.setPurlistTargetBill("src_purlistcomptpl");
        context.setPentitykey("src_project");
        context.setEntitykeys(Collections.singletonList("src_purlist_stand"));
        context.setSceneEntitykeys(SrcBotpUtils.getPurListTpl4Scene(sourceObjs));
        SrcBotpUtils.createProject((SrcBotpContext)context);
        interactionContext.setCustShowParameter(context.getResultMap());
    }
}

