/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.enroll;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enroll.IPdsEnrollHandler;
import kd.scm.pds.common.enroll.PdsEnrollContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class SrcSelectSupplierHandler
implements IPdsEnrollHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsEnrollContext context) {
        if (context.isAutoPublish() && context.isSucced()) {
            this.createSelectSupplier(context);
            this.saveSupplierObjs(context);
        }
    }

    protected void createSelectSupplier(PdsEnrollContext context) {
        ArrayList<DynamicObject> selectSupplierList = new ArrayList<DynamicObject>(16);
        int indexSeq = this.getIndexSeq(context);
        for (DynamicObject enrollSupplier : context.getEnrollSupplierList()) {
            DynamicObject supplierObj = SupplierUtil.createSupplierObj((String)"src_supplierinvite", (PdsEnrollContext)context, (int)indexSeq, (long)PdsCommonUtils.object2Long((Object)enrollSupplier.get("package_id")));
            supplierObj.set("supname", (Object)context.getBillObj().getString("supplier.name"));
            supplierObj.set("isconfirm", (Object)"1");
            supplierObj.set("isinvite", (Object)"1");
            supplierObj.set("note", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u63a8\u8350\u5165\u56f4\u3002", (String)"SrcSelectSupplierHandler_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            selectSupplierList.add(supplierObj);
            ++indexSeq;
        }
        context.setSelectSupplierList(selectSupplierList);
    }

    private int getIndexSeq(PdsEnrollContext context) {
        int indexSeq = 1;
        QFilter projectFilter = new QFilter("billid", "=", (Object)context.getProjectId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_supplierinvite", (String)"id", (QFilter[])projectFilter.toArray());
        if (null != rows && rows.size() > 0) {
            indexSeq = rows.size() + 1;
        }
        return indexSeq;
    }

    private void saveSupplierObjs(PdsEnrollContext context) {
        if (null == context.getEnrollSupplierList() || context.getEnrollSupplierList().size() == 0 || null == context.getSelectSupplierList() || context.getSelectSupplierList().size() == 0) {
            this.logErrorMessage(context, null, "EnrollSupplierList is null or SelectSupplierList is null");
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                PdsCommonUtils.saveDynamicObjects((List)context.getEnrollSupplierList());
                Set enrollEntryIds = context.getEnrollSupplierList().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                List enrollSupplierList = SupplierUtil.reloadSupplierList((String)"src_enrollsupplier", enrollEntryIds);
                context.setEnrollSupplierList(enrollSupplierList);
                PdsCommonUtils.saveDynamicObjects((List)context.getSelectSupplierList());
                Set selectEntryIds = context.getSelectSupplierList().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
                List selectSupplierList = SupplierUtil.reloadSupplierList((String)"src_supplierinvite", selectEntryIds);
                context.setSelectSupplierList(selectSupplierList);
            }
            catch (Exception e2) {
                h.markRollback();
                this.logErrorMessage(context, e2, null);
            }
        }
    }
}

