/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.enroll;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enroll.IPdsEnrollHandler;
import kd.scm.pds.common.enroll.PdsEnrollContext;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.src.common.util.SrcPublishUtils;

public class SrcTenderBillHandler
implements IPdsEnrollHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsEnrollContext context) {
        if (context.isAutoPublish() && context.isSucced()) {
            try {
                this.autoPublishHandle(context);
                this.updatePublishStatus(context);
            }
            catch (Exception e) {
                this.logErrorMessage(context, e, null);
            }
        }
    }

    private void autoPublishHandle(PdsEnrollContext context) {
        SrcPublishUtils.autoPublish((DynamicObject[])new DynamicObject[]{context.getProjectObj()}, (List)context.getSelectSupplierList());
    }

    private void updatePublishStatus(PdsEnrollContext context) {
        if (this.isAutoPublishSucced(context)) {
            Set selectEntryIds = context.getSelectSupplierList().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            SrcPublishUtils.updatePublishStatus((String)"src_supplierinvite", selectEntryIds);
        } else {
            this.logErrorMessage(context, null, ResManager.loadKDString((String)"\u6ca1\u6709\u81ea\u52a8\u521b\u5efa\u51fa\u6295\u6807\u5355\u6216\u62a5\u4ef7\u5355\u3002", (String)"SrcTenderBillHandler_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
        }
    }

    public boolean isAutoPublishSucced(PdsEnrollContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        Set selectEntryIds = context.getSelectSupplierList().stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection entryCols = SupplierUtil.reloadSupplierCollection((String)"src_supplierinvite", selectEntryIds);
        Set supplierIds = entryCols.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        qfilter.and("supplier", "in", supplierIds);
        return QueryServiceHelper.exists((String)"tnd_tenderbill", (QFilter[])qfilter.toArray()) || QueryServiceHelper.exists((String)"tnd_quotebill", (QFilter[])qfilter.toArray());
    }
}

