/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.ext;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.pds.common.extplugin.IExtendPlugin;
import kd.scm.pds.common.util.SupplierUtil;

public class SrcContractToEasPriceListValidator
extends AbstractValidator
implements IExtendPlugin {
    public void validate() {
        DynamicObject model;
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject row;
            model = rowDataEntity.getDataEntity();
            DynamicObjectCollection entryentity = model.getDynamicObjectCollection("entryentity");
            boolean flag = false;
            Iterator iterator = entryentity.iterator();
            while (iterator.hasNext() && (flag = SupplierUtil.isBdSupplier((DynamicObject)(row = (DynamicObject)iterator.next())))) {
                if (!SupplierUtil.isQZGYS((long)row.getLong("supplier_id"))) continue;
                this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u4f9b\u5e94\u5546\u4e3a\u6f5c\u5728\u4f9b\u5e94\u5546\u3002", (String)"SrcContractToEasPriceListValidator_4", (String)"scm-src-opplugin", (Object[])new Object[0]), row.getInt("seq")));
            }
            if (flag) continue;
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5148\u7ef4\u62a4\u6b63\u5f0f\u4f9b\u5e94\u5546\u6570\u636e\u540e\u518d\u5173\u8054\u751f\u6210\u4f9b\u8d27\u4ef7\u683c\u3002", (String)"SrcContractToEasPriceListValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            model = rowDataEntity.getDataEntity();
            long orgId = model.getLong("org.id");
            DynamicObjectCollection entryentitys = model.getDynamicObjectCollection("entryentity");
            HashSet<Integer> indexSet = new HashSet<Integer>(16);
            for (int i = 0; i < entryentitys.size(); ++i) {
                String sourcelistno;
                String pricelistno;
                boolean exists = this.isExistsMaterialPurchaseInfo(((DynamicObject)entryentitys.get(i)).getLong("material.id"), orgId);
                if (!exists) {
                    indexSet.add(i + 1);
                }
                if (StringUtils.isNotEmpty((CharSequence)(pricelistno = ((DynamicObject)entryentitys.get(i)).getString("pricelistid")))) {
                    this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5df2\u751f\u6210\u4f9b\u8d27\u4ef7\u683c,\u65e0\u6cd5\u518d\u6b21\u751f\u6210\u3002", (String)"SrcContractToEasPriceListValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), ((DynamicObject)entryentitys.get(i)).getInt("seq")));
                }
                if (!StringUtils.isNotEmpty((CharSequence)(sourcelistno = ((DynamicObject)entryentitys.get(i)).getString("sourcelistid")))) continue;
                this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5df2\u751f\u6210\u8d27\u6e90\u6e05\u5355,\u65e0\u6cd5\u518d\u6b21\u751f\u6210\u3002", (String)"SrcContractToEasPriceListValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), ((DynamicObject)entryentitys.get(i)).getInt("seq")));
            }
            if (CollectionUtils.isEmpty(indexSet)) continue;
            String indexStr = indexSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\u7269\u6599\u5728\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u518d\u4e0b\u63a8\u4f9b\u8d27\u4ef7\u683c\u548c\u8d27\u6e90\u6e05\u5355\u3002", (String)"SrcContractToEasPriceListValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), indexStr));
        }
    }

    private boolean isExistsMaterialPurchaseInfo(long materialId, long orgId) {
        QFilter masterFilter = new QFilter("masterid", "=", (Object)materialId);
        QFilter strategyFilter = BaseDataServiceHelper.getBaseDataFilter((String)FormMetadataCache.getFormConfig((String)"bd_materialpurchaseinfo").getEntityTypeId(), (Long)orgId);
        BizLog.log((String)("SrcContractUtils query materialpurchaseinfo filter:" + strategyFilter.and(masterFilter).toString()));
        return QueryServiceHelper.exists((String)"bd_materialpurchaseinfo", (QFilter[])new QFilter[]{strategyFilter.and(masterFilter)});
    }
}

