/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidDocTypeEnums;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcBidDocValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData srcValidatorData) {
        DynamicObject billObj = srcValidatorData.getBillObj();
        Boolean isneedbiddoc = billObj.getBoolean("srctype.isneedbiddoc");
        if (!isneedbiddoc.booleanValue()) {
            return;
        }
        String bidDoc = billObj.getString("srctype.biddoc");
        if (StringUtils.isBlank((CharSequence)bidDoc)) {
            return;
        }
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        DynamicObject purBidDocObj = TemplateUtil.getComponentData((String)String.valueOf(projectId), (String)"src_biddoc_src");
        if (null == purBidDocObj) {
            return;
        }
        DynamicObjectCollection docRows = purBidDocObj.getDynamicObjectCollection("entryentity");
        if (null == docRows || docRows.size() == 0) {
            this.getUnSuccedResult(srcValidatorData, ResManager.loadKDString((String)"\u8be5\u5bfb\u6e90\u6d41\u7a0b\u9700\u8981\u4e0a\u4f20\u91c7\u8d2d\u65b9\u6807\u4e66\u6587\u4ef6\uff0c\u8bf7\u6309\u8981\u6c42\u4e0a\u4f20\u6807\u4e66\u6587\u4ef6\u3002", (String)"SrcBidDocValidator_4", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        String manageType = billObj.getString("managetype");
        StringBuilder sb = new StringBuilder();
        Set bidDocTypes = Arrays.stream(bidDoc.split(",")).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).collect(Collectors.toSet());
        for (String bidDocType : bidDocTypes) {
            this.verifyBidDoc(docRows, bidDocType, manageType, sb);
        }
        if (sb.length() > 0) {
            srcValidatorData.setSucced(false);
            String str = sb.toString();
            if (str.length() > 1 && str.endsWith(";")) {
                str = str.substring(0, str.length() - 1);
            }
            srcValidatorData.setMessage(str);
            return;
        }
    }

    private void verifyBidDoc(DynamicObjectCollection docRows, String bidDocType, String manageType, StringBuilder sb) {
        if ("1".equals(manageType) || "3".equals(manageType)) {
            Boolean notmatch = docRows.stream().noneMatch(row -> bidDocType.equals(row.getString("packfiletype")));
            if (notmatch.booleanValue()) {
                sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20%1$s\u3002", (String)"SrcBidDocValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), BidDocTypeEnums.getBidDocTypeName((String)bidDocType))).append(";");
            }
            return;
        }
        ArrayList<String> packageNames = new ArrayList<String>();
        Map<String, List<DynamicObject>> groupMap = docRows.stream().filter(row -> row.get("package.id") != null).collect(Collectors.groupingBy(row -> row.getString("package.packagename")));
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            Boolean notmatch = entry.getValue().stream().noneMatch(obj -> bidDocType.equals(obj.getString("packfiletype")));
            if (!notmatch.booleanValue()) continue;
            packageNames.add(entry.getKey());
        }
        if (packageNames == null || packageNames.size() == 0) {
            return;
        }
        for (String packageName : packageNames) {
            sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6807\u6bb5(%1$s)\u7684%2$s\u3002", (String)"SrcBidDocValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName, BidDocTypeEnums.getBidDocTypeName((String)bidDocType))).append(";");
        }
    }
}

