/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import org.apache.commons.collections.CollectionUtils;

public class SrcBidOpenCfgExpertCountValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        if (null == context.getBillObj()) {
            return;
        }
        DynamicObjectCollection rows = context.getBillObj().getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        StringBuilder message = new StringBuilder();
        int index = 1;
        for (DynamicObject row : rows) {
            int expertCount = row.get("expertcount") == null ? 0 : row.getInt("expertcount");
            if (expertCount == 0) continue;
            DynamicObjectCollection scorers = row.getDynamicObjectCollection("scorer");
            int scorersSize = CollectionUtils.isEmpty((Collection)scorers) ? 0 : scorers.size();
            if (scorersSize < expertCount) {
                message.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u8bc4\u59d4\u4eba\u6570(%2$s), \u4e0d\u7b26\u5408\u8981\u6c42(%3$s)%4$s\u3002", (String)"SrcBidOpenCfgExpertCountValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), index, scorersSize, expertCount, "\n"));
            }
            ++index;
        }
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            context.setSucced(false);
            context.setMessage(message.toString());
        }
    }
}

