/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcBidOpenCfgIndexTypeValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        DynamicObjectCollection entryCols = billObj.getDynamicObjectCollection("entryentity");
        boolean isTec = false;
        boolean isBiz = false;
        boolean isOth = false;
        boolean isSyn = false;
        BigDecimal ratio_tec = billObj.getBigDecimal("ratio_tec") == null ? BigDecimal.ZERO : billObj.getBigDecimal("ratio_tec");
        BigDecimal ratio_biz = billObj.getBigDecimal("ratio_biz") == null ? BigDecimal.ZERO : billObj.getBigDecimal("ratio_biz");
        BigDecimal ratio_oth = billObj.getBigDecimal("ratio_oth") == null ? BigDecimal.ZERO : billObj.getBigDecimal("ratio_oth");
        BigDecimal ratio_syn = billObj.getBigDecimal("ratio_syn") == null ? BigDecimal.ZERO : billObj.getBigDecimal("ratio_syn");
        QFilter filter = new QFilter("project", "=", billObj.getPkValue());
        DynamicObjectCollection packageCols = QueryServiceHelper.query((String)"src_packagef7", (String)"id,packagename", (QFilter[])filter.toArray());
        HashMap<String, String> packageMap = new HashMap<String, String>();
        if (packageCols != null && packageCols.size() > 0) {
            for (DynamicObject packageObj : packageCols) {
                packageMap.put(packageObj.getString("id"), packageObj.getString("packagename"));
            }
        } else {
            boolean ismultipackage = billObj.getBoolean("ismultipackage");
            if (ismultipackage) {
                this.getUnSuccedResult(context, ResManager.loadKDString((String)"\u7ba1\u7406\u65b9\u5f0f\u4e3a\u6309\u6807\u6bb5\uff0c\u6807\u6bb5\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u9009\u62e9\u6807\u6bb5\u3002", (String)"SrcBidOpenCfgIndexTypeValidator_8", (String)"scm-src-opplugin", (Object[])new Object[0]));
                return;
            }
        }
        HashMap<String, Boolean> packageTecMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> packageBizMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> packageOthMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> packageSynMap = new HashMap<String, Boolean>();
        for (DynamicObject entryData : entryCols) {
            DynamicObject indexType = entryData.getDynamicObject("indextype");
            String type = indexType == null ? "" : indexType.getString("basetype");
            DynamicObject packageObj = entryData.getDynamicObject("package");
            String packageId = "0";
            if (packageObj != null) {
                packageId = packageObj.getString("id");
            } else if (packageCols != null && packageCols.size() == 1) {
                packageId = ((DynamicObject)packageCols.get(0)).getString("id");
            }
            if (StringUtils.equals((CharSequence)"1", (CharSequence)type)) {
                packageTecMap.put(packageId, Boolean.TRUE);
            }
            if (StringUtils.equals((CharSequence)"2", (CharSequence)type)) {
                packageBizMap.put(packageId, Boolean.TRUE);
            }
            if (StringUtils.equals((CharSequence)"3", (CharSequence)type)) {
                packageOthMap.put(packageId, Boolean.TRUE);
            }
            if (!StringUtils.equals((CharSequence)"6", (CharSequence)type)) continue;
            packageSynMap.put(packageId, Boolean.TRUE);
        }
        StringBuilder message = new StringBuilder();
        for (Map.Entry entry : packageMap.entrySet()) {
            String packageId = (String)entry.getKey();
            isTec = false;
            isBiz = false;
            isOth = false;
            isSyn = false;
            String packageName = (String)entry.getValue();
            if (billObj.getBoolean("isbyproject")) {
                if (packageSynMap.get(packageId) != null) {
                    isSyn = (Boolean)packageSynMap.get(packageId);
                    isTec = true;
                    isBiz = true;
                    isOth = true;
                }
            } else {
                if (packageTecMap.get(packageId) != null) {
                    isTec = (Boolean)packageTecMap.get(packageId);
                }
                if (packageBizMap.get(packageId) != null) {
                    isBiz = (Boolean)packageBizMap.get(packageId);
                }
                if (packageOthMap.get(packageId) != null) {
                    isOth = (Boolean)packageOthMap.get(packageId);
                }
                isSyn = true;
            }
            if (!isTec && ratio_tec.compareTo(BigDecimal.ZERO) > 0) {
                if (Objects.equals(packageName, "ByItem")) {
                    message.append(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u6280\u672f\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcBidOpenCfgIndexTypeValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0])).append("\n");
                } else {
                    message.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u672a\u7ef4\u62a4\u6280\u672f\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcBidOpenCfgIndexTypeValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName)).append("\n");
                }
            }
            if (!isBiz && ratio_biz.compareTo(BigDecimal.ZERO) > 0) {
                if (Objects.equals(packageName, "ByItem")) {
                    message.append(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u5546\u52a1\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcBidOpenCfgIndexTypeValidator_6", (String)"scm-src-opplugin", (Object[])new Object[0])).append("\n");
                } else {
                    message.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5\u201c%1$s\u201d\u672a\u7ef4\u62a4\u5546\u52a1\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcBidOpenCfgIndexTypeValidator_7", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName)).append("\n");
                }
            }
            if (!isOth && ratio_oth.compareTo(BigDecimal.ZERO) > 0) {
                if (Objects.equals(packageName, "ByItem")) {
                    message.append(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u5546\u52a1\u7efc\u5408\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcBidOpenCfgIndexTypeValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0])).append("\n");
                } else {
                    message.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5(%1$s)\u672a\u7ef4\u62a4\u5546\u52a1\u7efc\u5408\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcBidOpenCfgIndexTypeValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName)).append("\n");
                }
            }
            if (isSyn || ratio_syn.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (Objects.equals(packageName, "ByItem")) {
                message.append(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u7efc\u5408\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcBidOpenCfgIndexTypeValidator_4", (String)"scm-src-opplugin", (Object[])new Object[0])).append("\n");
                continue;
            }
            message.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5\u201c%1$s\u201d\u672a\u7ef4\u62a4\u7efc\u5408\u8bc4\u6807\u65b9\u6848\u3002", (String)"SrcBidOpenCfgIndexTypeValidator_5", (String)"scm-src-opplugin", (Object[])new Object[0]), packageName)).append("\n");
        }
        if (message.length() > 0) {
            this.getUnSuccedResult(context, message.toString());
        }
    }
}

