/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcBidPackageNameRepeatValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObjectCollection rows = context.getBillObj().getDynamicObjectCollection("entryentity");
        if (null == rows || rows.size() == 0) {
            return;
        }
        Map<String, Integer> packageMap = rows.stream().collect(Collectors.groupingBy(e -> e.getString("packagename"), Collectors.collectingAndThen(Collectors.toList(), value -> value.size())));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : packageMap.entrySet()) {
            if (entry.getValue() <= 1) continue;
            sb.append(entry.getKey()).append(",");
        }
        if (sb.length() > 0) {
            context.setSucced(false);
            context.setMessage(String.format(ResManager.loadKDString((String)"\u8fd9\u4e9b\u6807\u5305\u540d\u79f0\u91cd\u590d\u4e86\uff0c\u8bf7\u4fee\u6539\uff1a%1$s\u3002", (String)"SrcBidPackageNameRepeatValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), sb.toString().substring(0, sb.length() - 1)));
            return;
        }
    }
}

