/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcBiddocRepeatedValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        DynamicObjectCollection allAttachRows = new DynamicObjectCollection();
        DynamicObjectCollection entryRows = billObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : entryRows) {
            DynamicObjectCollection attachRows = entryRow.getDynamicObjectCollection("bidattach");
            if (null == attachRows || attachRows.size() == 0) continue;
            allAttachRows.addAll((Collection)attachRows);
        }
        if (null == allAttachRows || allAttachRows.size() == 0) {
            return;
        }
        StringBuilder message = new StringBuilder();
        Map<String, List<DynamicObject>> groupMap = allAttachRows.stream().collect(Collectors.groupingBy(e -> e.getString("fbasedataid.type") + e.getString("fbasedataid.name") + e.getString("fbasedataid.size")));
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            message.append(entry.getValue().get(0).getString("fbasedataid.name"));
            message.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u91cd\u590d\u4e86%1$s\u6b21\u3002\n", (String)"SrcBiddocRepeatedValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), entry.getValue().size()));
        }
        if (message.length() > 0) {
            context.setSucced(false);
            context.setMessage(message.toString());
        }
    }
}

