/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.PdsLettersTypeEnum;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.util.SrcWinruleUtils;

public class SrcDecisionOrderRatioValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        this.verifyOrderRatio(context);
    }

    protected void verifyOrderRatio(SrcValidatorData context) {
        String qtyMaterialName;
        StringBuilder sb = new StringBuilder();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        if (!SrcWinruleUtils.isNeedValidateOrderRatio((long)projectId)) {
            return;
        }
        QFilter qFilter = new QFilter("project.id", "=", (Object)projectId);
        qFilter.and("isdiscarded", "=", (Object)"0");
        qFilter.and("entrystatus", "=", (Object)"C");
        if (null != context.getPurlistIds() && context.getPurlistIds().size() > 0) {
            qFilter.and("purlist", "in", (Object)context.getPurlistIds());
        }
        String selectFields = "purlist.id,purlist.materialnane,result,entrystatus,orderratio,qty,cfmqty";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])qFilter.toArray());
        Object orderRatioObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"orderratio");
        String orderRatio = String.valueOf(orderRatioObj == null ? ",1,2,5," : orderRatioObj);
        List orderRatioIndex = Arrays.stream(orderRatio.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        boolean orderRatioIsBreak = rows.stream().filter(row -> orderRatioIndex.contains(row.getString("result"))).filter(row -> Objects.equals(ProjectStatusEnums.OPENED.getValue(), row.getString("entrystatus"))).anyMatch(e -> BigDecimal.ZERO.compareTo(e.getBigDecimal("orderratio")) == 0);
        if (orderRatioIsBreak) {
            String message = orderRatioIndex.stream().map(str -> PdsLettersTypeEnum.fromVal((String)str).getName()).collect(Collectors.joining("/"));
            sb.append(String.format(ResManager.loadKDString((String)"%1$s\u4f9b\u5e94\u5546\u4efd\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcDecisionOrderRatioValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), message));
        }
        ArrayList<String> tatioResult = new ArrayList<String>(16);
        ArrayList<String> qtyResult = new ArrayList<String>(16);
        Map<String, List<DynamicObject>> purListMap = rows.stream().filter(row -> orderRatioIndex.contains(row.getString("result"))).filter(row -> Objects.equals(ProjectStatusEnums.OPENED.getValue(), row.getString("entrystatus"))).collect(Collectors.groupingBy(row -> row.getString("purlist.id")));
        for (Map.Entry<String, List<DynamicObject>> purListEntry : purListMap.entrySet()) {
            BigDecimal qty;
            BigDecimal qtySum;
            List<DynamicObject> entries = purListEntry.getValue();
            if (entries.size() == 1) continue;
            BigDecimal tatioSum = entries.stream().map(e -> e.getBigDecimal("orderratio")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (tatioSum.compareTo(new BigDecimal(100)) != 0) {
                tatioResult.add(purListEntry.getValue().get(0).getString("purlist.materialnane"));
            }
            if ((qtySum = entries.stream().map(e -> e.getBigDecimal("cfmqty")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(qty = entries.get(0).getBigDecimal("qty")) == 0) continue;
            qtyResult.add(purListEntry.getValue().get(0).getString("purlist.materialnane"));
        }
        String tatioMaterialName = String.join((CharSequence)",", tatioResult);
        if (StringUtils.isNotEmpty((String)tatioMaterialName)) {
            sb.append(String.format(ResManager.loadKDString((String)"\u6807\u7684\u540d\u79f0\u4e3a%1$s\u7684\u4efd\u989d\u4e4b\u548c\u5fc5\u987b\u4e3a100\u3002", (String)"SrcDecisionOrderRatioValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), tatioMaterialName));
        }
        if (StringUtils.isNotEmpty((String)(qtyMaterialName = String.join((CharSequence)",", qtyResult)))) {
            sb.append(String.format(ResManager.loadKDString((String)"\u6807\u7684\u540d\u79f0\u4e3a\u201c%1$s\u201d\u7684\u5b9a\u6807\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u6807\u7684\u6570\u91cf\u3002", (String)"SrcDecisionOrderRatioValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), qtyMaterialName));
        }
        if (sb.length() > 0) {
            context.setMessage(sb.toString());
            context.setSucced(false);
        }
    }
}

