/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcDecisionSignRateValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        this.verifySignRate(context);
    }

    protected void verifySignRate(SrcValidatorData context) {
        String pentitykey = context.getBillObj().getString("pentitykey");
        if (!Objects.equals(pentitykey, "src_decision")) {
            return;
        }
        DynamicObjectCollection entryRows = context.getBillObj().getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : entryRows) {
            DynamicObjectCollection subRows = entryRow.getDynamicObjectCollection("subentryentity");
            BigDecimal signRate = subRows.stream().map(e -> e.getBigDecimal("signrate")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (signRate.compareTo(new BigDecimal(100)) == 0) continue;
            String rate = signRate.setScale(2, 5).toString();
            context.setMessage(String.format(ResManager.loadKDString((String)"\u7b7e\u7ea6\u4f9b\u5e94\u5546\u5206\u914d\u6bd4\u4f8b\u4e4b\u548c(%1$s)\uff0c\u4e0d\u7b49\u4e8e100\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcDecisionSignRateValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), rate));
            context.setSucced(false);
        }
    }
}

