/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcDecisionSupplierValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> propertys = new HashSet<String>(8);
        propertys.add("entry");
        propertys.add("entry.purtype");
        propertys.add("entry.suppliers");
        propertys.add("entry.scenename_des1");
        return propertys;
    }

    public void validate(SrcValidatorData validatorData) {
        StringBuilder sb = new StringBuilder();
        Set sourceTypeSet = PdsCommonUtils.buildSet((Long[])new Long[]{SourceTypeEnums.DIRECT_PUR.getId(), SourceTypeEnums.NET_PUR.getId(), SourceTypeEnums.INPUT_PRICE.getId(), SourceTypeEnums.CONFIRM_PRICE.getId(), SourceTypeEnums.INTERNAL_SALE.getId()});
        DynamicObjectCollection sceneRows = validatorData.getBillObj().getDynamicObjectCollection("entry");
        for (DynamicObject sceneRow : sceneRows) {
            DynamicObjectCollection supplierRows;
            if (!sourceTypeSet.contains(sceneRow.getLong("purtype.id")) || (supplierRows = sceneRow.getDynamicObjectCollection("suppliers")).size() <= 1) continue;
            sb.append(sceneRow.getString("scenename_des1")).append("--");
            sb.append(sceneRow.getString("purtype.name"));
            sb.append("\uff1a");
            sb.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u6570\u91cf\u4e3a\uff1a%s\uff0c\u8bf7\u4fee\u6539\u4e3a\u4e00\u4e2a\u4f9b\u5e94\u5546\u3002", (String)"SrcDecisionSupplierValidator_8", (String)"scm-src-opplugin", (Object[])new Object[0]), supplierRows.size()));
            sb.append("\n");
        }
        if (sb.length() > 0) {
            validatorData.setMessage(sb.toString());
            validatorData.setSucced(false);
        }
    }
}

