/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcExpertEvaluatePushValidator2
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        long billId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        DynamicObject[] scorers = BusinessDataServiceHelper.load((String)"src_evaluateconfigf7", (String)"scorer", (QFilter[])qFilter.toArray());
        if (scorers.length == 0) {
            return;
        }
        HashSet scorerSet = new HashSet(4);
        for (DynamicObject scorer : scorers) {
            scorerSet.addAll(MultiBasedataUtils.getBasedataIdSet((DynamicObject)scorer, (String)"scorer"));
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_evaluateexpertf7", (String)"supplier.user.id", (QFilter[])qFilter.toArray());
        if (rows.size() == 0) {
            return;
        }
        Set expertSet = rows.stream().map(e -> e.getLong("supplier.user.id")).collect(Collectors.toSet());
        Set userSet = PdsCommonUtils.getIntersectSet(scorerSet, expertSet);
        if (userSet.size() > 0) {
            QFilter qfilter = new QFilter("id", "in", (Object)userSet);
            DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"number,name", (QFilter[])qfilter.toArray());
            Set userNames = users.stream().map(e -> e.getString("name")).collect(Collectors.toSet());
            this.getUnSuccedResult(context, String.format(ResManager.loadKDString((String)"\u8fd9\u4e9b\u8bc4\u59d4\u4e0e\u4e13\u5bb6\u91cd\u53e0\uff0c\u8bc4\u59d4\u4e0d\u5141\u8bb8\u81ea\u5df1\u8bc4\u81ea\u5df1\uff1a %1$s\u3002", (String)"SrcExpertEvaluatePushValidator2_0", (String)"scm-src-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", userNames)));
        }
    }
}

