/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcGradeScoreContinueValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows.size() == 0) {
            return;
        }
        int index = 0;
        StringBuilder message = new StringBuilder();
        for (DynamicObject row : rows) {
            if (index > 0) {
                message.append((CharSequence)this.veryfyRange(row, (DynamicObject)rows.get(index - 1), "scorefrom", "scoreto", index));
            }
            ++index;
        }
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            context.setSucced(false);
            context.setMessage(message.toString());
        }
    }

    private StringBuilder veryfyRange(DynamicObject row, DynamicObject preRow, String scoreFromField, String scoreFromTo, int index) {
        StringBuilder sb = new StringBuilder();
        if (row.getBigDecimal(scoreFromTo).compareTo(preRow.getBigDecimal(scoreFromField)) != 0) {
            sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u884c{0}\uff1a\u672c\u884c\u7684\u201c\u8003\u8bc4\u5f97\u5206\u81f3\u201d \u5e94\u7b49\u4e8e \u4e0a\u4e00\u884c\u7684\u201c\u8003\u8bc4\u5f97\u5206\u4ece\u201d\u3002", (String)"SrcGradeScoreContinueValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), index + 1));
            sb.append('\n');
        }
        return sb;
    }
}

