/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcGradeScoreRangeValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (rows.size() == 0) {
            return;
        }
        int index = 0;
        StringBuilder message = new StringBuilder();
        for (DynamicObject row : rows) {
            message.append((CharSequence)this.veryfyRange(row, "scorefrom", "scoreto", index));
            ++index;
        }
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            this.getUnSuccedResult(context, message.toString());
        }
    }

    private StringBuilder veryfyRange(DynamicObject row, String scoreFromField, String scoreFromTo, int index) {
        StringBuilder sb = new StringBuilder();
        if (row.getBigDecimal(scoreFromField).compareTo(row.getBigDecimal(scoreFromTo)) >= 0) {
            sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u884c{0}\uff1a\u201c\u8003\u8bc4\u5f97\u5206\u4ece\u201d\u5e94\u5c0f\u4e8e\u201c\u8003\u8bc4\u5f97\u5206\u81f3\u201d\u3002", (String)"SrcGradeScoreRangeValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), index + 1));
            sb.append('\n');
        }
        return sb;
    }
}

