/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcInviteSupplierEntrySubmitValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        String sourceType = billObj.getString("sourcetype.number");
        if (SourceTypeEnums.CONFIRM_PRICE.getValue().equals(sourceType)) {
            return;
        }
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entrysupplier");
        List entry = null;
        entry = rows.stream().filter(row -> row.getBoolean("isinvite")).collect(Collectors.toList());
        if (entry == null || entry.size() == 0) {
            this.getUnSuccedResult(context, ResManager.loadKDString((String)"\u672a\u9080\u8bf7\u4f9b\u5e94\u5546", (String)"SrcInviteSupplierEntrySubmitValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        long parentId = billObj.getLong("parentid");
        DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"managetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId)});
        if (projectObj == null) {
            return;
        }
        String managetype = projectObj.getString("managetype");
        if ("1".equals(managetype) || "3".equals(managetype)) {
            return;
        }
        List<Long> projectPackage = this.getPackage(billObj);
        List entryPackage = entry.stream().filter(row -> row.get("package.id") != null).map(row -> row.getLong("package.id")).distinct().collect(Collectors.toList());
        if (projectPackage != null && projectPackage.size() > 0 && entryPackage != null && entryPackage.size() > 0) {
            projectPackage.removeAll(entryPackage);
        }
        if (projectPackage == null || projectPackage.size() == 0) {
            return;
        }
        DynamicObjectCollection packageObjs = QueryServiceHelper.query((String)"src_packagef7", (String)"packagename", (QFilter[])new QFilter[]{new QFilter("package.id", "in", projectPackage)});
        StringBuilder sb = new StringBuilder();
        for (DynamicObject packageObj : packageObjs) {
            sb.append(packageObj.getString("packagename"));
            sb.append(',');
        }
        StringBuilder message = new StringBuilder(String.format(ResManager.loadKDString((String)"\u6807\u6bb5\uff1a%1$s\u672a\u9080\u8bf7\u4f9b\u5e94\u5546\u3002\u5982\u679c\u8be5\u6807\u6bb5\u65e0\u4f9b\u5e94\u5546\u62a5\u540d\uff0c\u8bf7\u53d1\u8d77\u201c\u6807\u7684\u6d41\u6807\u53d8\u66f4\u201d\uff0c\u5c06\u8be5\u6807\u6bb5\u4e0b\u6240\u6709\u6807\u7684\u90fd\u8fdb\u884c\u6d41\u6807\u5904\u7406\u3002", (String)"SrcInviteSupplierEntrySubmitValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), sb));
        this.getUnSuccedResult(context, message.toString());
    }

    private List<Long> getPackage(DynamicObject dataEntity) {
        ArrayList<Long> packagelist = new ArrayList();
        long projectId = dataEntity.getLong("parentid");
        QFilter qFilter = new QFilter("project", "=", (Object)projectId);
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)projectId);
        qFilter.and("purlist", "not in", (Object)purListEndIds);
        qFilter.and("package", ">", (Object)0);
        qFilter.and("isbizitem", "=", (Object)"0");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"package.id", (QFilter[])new QFilter[]{qFilter});
        packagelist = rows.stream().map(row -> row.getLong("package.id")).distinct().collect(Collectors.toList());
        return packagelist;
    }
}

