/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.util.SrcAppCache;

public class SrcInviteSupplierNumberValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        if (Objects.equals(billObj.getDataEntityType().getName(), "src_supplier_invite")) {
            this.validateRepeatSuppliers(context);
            if (!context.isSucced()) {
                return;
            }
        }
        this.validateWinSuppliers(context);
        if (!context.isSucced()) {
            return;
        }
    }

    public void validateRepeatSuppliers(SrcValidatorData context) {
        String managetype = context.getBillObj().getString("projectf7.managetype");
        DynamicObjectCollection rows = context.getBillObj().getDynamicObjectCollection("entrysupplier");
        Function<DynamicObject, String> function = e -> e.getString("package.id") + "|" + e.getString("supplier.id");
        Map<String, List<DynamicObject>> groupMap = rows.stream().collect(Collectors.groupingBy(function));
        if (groupMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> row = entry.getValue();
            if (row.size() <= 1) continue;
            if ("1".equals(managetype) || "3".equals(managetype)) {
                context.setMessage(MessageFormat.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546:{0}\u91cd\u590d\u3002", (String)"SrcInviteSupplierNumberValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), row.get(0).getString("supplier.name")));
            } else {
                context.setMessage(MessageFormat.format(ResManager.loadKDString((String)"\u6807\u6bb5:{0}\u7684\u4f9b\u5e94\u5546:{1}\u91cd\u590d\u3002", (String)"SrcInviteSupplierNumberValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), row.get(0).getString("package.packagename"), row.get(0).getString("supplier.name")));
            }
            context.setSucced(false);
        }
    }

    public void validateWinSuppliers(SrcValidatorData context) {
        IFormView parentView = context.getView().getParentView();
        DynamicObject parentObj = parentView.getModel().getDataEntity(true);
        String pentityKey = parentView.getEntityId();
        if ("src_project".equals(pentityKey) || "src_invitesupplier".equals(pentityKey)) {
            String managetype = parentObj.getString("managetype");
            int winSupplier = 0;
            int bidNumber = 0;
            if ("src_project".equals(pentityKey)) {
                String vieRulePageId;
                IFormView vieRulePage;
                String winRulePageId = (String)SrcAppCache.get((String)"winrulepageid", String.class, (IFormView)parentView);
                IFormView winRulePage = parentView.getView(winRulePageId);
                if (Objects.nonNull(winRulePage)) {
                    winSupplier = winRulePage.getModel().getDataEntity().getInt("winerqty");
                    bidNumber = winRulePage.getModel().getDataEntity().getInt("biderqty");
                }
                if (Objects.nonNull(vieRulePage = parentView.getView(vieRulePageId = (String)SrcAppCache.get((String)"vierulepageid", String.class, (IFormView)parentView)))) {
                    winSupplier = vieRulePage.getModel().getDataEntity().getInt("winerqty");
                    bidNumber = vieRulePage.getModel().getDataEntity().getInt("bidnumber");
                }
            } else {
                DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)parentObj.getPkValue(), (String)"src_projectf7");
                winSupplier = projectObj.getInt("winerqty");
                List compKeys = TemplateUtil.getAllCompKeyListByTplEntry((DynamicObject)parentObj);
                bidNumber = compKeys.contains("src_vie_rule") ? projectObj.getInt("bidnumber") : projectObj.getInt("biderqty");
            }
            DynamicObjectCollection rows = context.getBillObj().getDynamicObjectCollection(this.getEntryKey(context));
            if (rows == null || rows.size() == 0) {
                return;
            }
            Map<Object, Object> groupMap = new HashMap();
            if (Objects.equals(managetype, "1")) {
                groupMap = rows.stream().filter(row -> row.getBoolean("isinvite")).collect(Collectors.groupingBy(row -> row.getString("entryparentid")));
            } else if (Objects.equals(managetype, "2")) {
                groupMap = rows.stream().filter(row -> row.getBoolean("isinvite") && row.get("package") != null).collect(Collectors.groupingBy(row -> row.getString("package.id")));
            } else if (Objects.equals(managetype, "3")) {
                groupMap = rows.stream().filter(row -> Objects.nonNull(row.get("purlist"))).collect(Collectors.groupingBy(row -> row.getString("purlist.id")));
            }
            StringBuilder winBuilder = new StringBuilder();
            StringBuilder bidBuilder = new StringBuilder();
            for (Map.Entry<Object, Object> entry : groupMap.entrySet()) {
                int qty = 0;
                if (Objects.equals(managetype, "1") || Objects.equals(managetype, "2")) {
                    qty = ((List)entry.getValue()).size();
                } else if (Objects.equals(managetype, "3")) {
                    qty = ((DynamicObject)((List)entry.getValue()).get(0)).getDynamicObjectCollection("supplier").size();
                }
                if (qty < winSupplier) {
                    this.joinNames(winBuilder, managetype, (List)entry.getValue());
                }
                if (qty >= bidNumber) continue;
                this.joinNames(bidBuilder, managetype, (List)entry.getValue());
            }
            StringBuilder message = new StringBuilder();
            if (winBuilder.length() > 0) {
                if (Objects.equals("1", managetype)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5c0f\u4e8e\u4e2d\u6807\u4f9b\u5e94\u5546\u6570\u91cf(%1$s\u4e2a)%2$s\u3002", (String)"SrcInviteSupplierNumberValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), winSupplier, "\n"));
                } else if (Objects.equals("2", managetype)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5\uff1a%1$s\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5c0f\u4e8e\u4e2d\u6807\u4f9b\u5e94\u5546\u6570\u91cf(%2$s\u4e2a)%3$s\u3002", (String)"SrcInviteSupplierNumberValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), winBuilder.substring(0, winBuilder.length() - 1), winSupplier, "\n"));
                } else if (Objects.equals("3", managetype)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6807\u7684\uff1a%1$s\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5c0f\u4e8e\u4e2d\u6807\u4f9b\u5e94\u5546\u6570\u91cf(%2$s\u4e2a)%3$s\u3002", (String)"SrcInviteSupplierNumberValidator_4", (String)"scm-src-opplugin", (Object[])new Object[0]), winBuilder.substring(0, winBuilder.length() - 1), winSupplier, "\n"));
                }
            }
            if (bidBuilder.length() > 0) {
                if (Objects.equals("1", managetype)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5c0f\u4e8e\u6700\u4f4e\u53c2\u4e0e\u4f9b\u5e94\u5546\u6570\u91cf(%1$s\u4e2a)%2$s\u3002", (String)"SrcInviteSupplierNumberValidator_5", (String)"scm-src-opplugin", (Object[])new Object[0]), bidNumber, "\n"));
                } else if (Objects.equals("2", managetype)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6807\u6bb5\uff1a%1$s\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5c0f\u4e8e\u6700\u4f4e\u53c2\u4e0e\u4f9b\u5e94\u5546\u6570\u91cf(%2$s\u4e2a)%3$s\u3002", (String)"SrcInviteSupplierNumberValidator_6", (String)"scm-src-opplugin", (Object[])new Object[0]), bidBuilder.substring(0, bidBuilder.length() - 1), bidNumber, "\n"));
                } else if (Objects.equals("3", managetype)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6807\u7684\uff1a%1$s\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u5c0f\u4e8e\u6700\u4f4e\u53c2\u4e0e\u4f9b\u5e94\u5546\u6570\u91cf(%2$s\u4e2a)%3$s\u3002", (String)"SrcInviteSupplierNumberValidator_7", (String)"scm-src-opplugin", (Object[])new Object[0]), bidBuilder.substring(0, bidBuilder.length() - 1), bidNumber, "\n"));
                }
            }
            if (message.length() > 0) {
                context.setMessage(message.toString());
                context.setSucced(false);
            }
        }
    }

    private String getEntryKey(SrcValidatorData context) {
        String entryKey = "entryentity";
        String entityId = context.getBillObj().getDataEntityType().getName();
        if (Objects.equals(entityId, "src_supplier_invite")) {
            entryKey = "entrysupplier";
        } else if (Objects.equals(entityId, "src_itemsupplier")) {
            entryKey = "entryentity";
        }
        return entryKey;
    }

    private void joinNames(StringBuilder stringBuilder, String managetype, List<DynamicObject> objs) {
        String name = null;
        if ("1".equals(managetype)) {
            name = "ByItem";
        } else if ("2".equals(managetype)) {
            name = objs.get(0).getString("package.packagename");
        } else if ("3".equals(managetype)) {
            name = objs.get(0).getString("purlist.materialnane");
        }
        stringBuilder.append(name);
        stringBuilder.append('\u3001');
    }
}

