/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcItemSupplierPurListValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        context.setSucced(true);
        if (null == context.getBillObj()) {
            return;
        }
        DynamicObjectCollection rows = context.getBillObj().getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return;
        }
        boolean isChanged = false;
        Iterator ite = rows.iterator();
        while (ite.hasNext()) {
            DynamicObject row2 = (DynamicObject)ite.next();
            if (row2.getLong("purlist.id") != 0L) continue;
            ite.remove();
            isChanged = true;
        }
        List supPurListIds = rows.stream().map(row -> row.getLong("purlist.id")).distinct().collect(Collectors.toList());
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)Long.parseLong(context.getBillObj().getString("parentid")));
        QFilter filter = new QFilter("project", "=", (Object)Long.valueOf(context.getBillObj().getString("parentid")));
        filter.and("purlist.id", "not in", (Object)purListEndIds);
        filter.and("isbizitem", "=", (Object)"0");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist", (QFilter[])filter.toArray());
        List purListIds = cols.stream().map(col -> col.getLong("purlist")).distinct().collect(Collectors.toList());
        if (!PdsCommonUtils.isEqualCollection(supPurListIds, purListIds)) {
            this.getUnSuccedResult(context, ResManager.loadKDString((String)"\u6807\u7684\u4f9b\u5e94\u5546\u6807\u7684\u4e0e\u91c7\u8d2d\u6e05\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"SrcItemSupplierPurListValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        if (isChanged) {
            PdsCommonUtils.saveDynamicObjects((DynamicObject)context.getBillObj());
        }
    }
}

