/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcNegotiateOpenQuoteNumValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData validatorData) {
        DynamicObject negBillObj = validatorData.getBillObj();
        String passType = PdsCommonUtils.object2String((Object)negBillObj.get("quotenum"), (String)"");
        if (passType.equals("") || passType.equals("0")) {
            return;
        }
        QFilter qfilters = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)negBillObj.getDynamicObject("project")));
        qfilters.and("turns", "=", (Object)negBillObj.getString("turns"));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"tnd_quotebill", (String)"billstatus", (QFilter[])qfilters.toArray());
        if (null == rows || rows.size() == 0) {
            return;
        }
        int finishNum = (int)rows.stream().filter(e -> e.getString("billstatus").equals(BillStatusEnum.AUDIT.getVal())).count();
        StringBuilder sb = this.verifyFinishNum(passType, finishNum, rows.size());
        if (sb.length() > 0) {
            validatorData.setSucced(false);
            validatorData.setMessage(sb.toString());
            return;
        }
    }

    private StringBuilder verifyFinishNum(String passType, int finishNum, int allNum) {
        StringBuilder sb = new StringBuilder();
        switch (passType) {
            case "1": {
                if (finishNum != 0) break;
                sb.append((CharSequence)this.buildMessage(finishNum, 1));
                break;
            }
            case "2": {
                if (finishNum >= PdsCommonUtils.getMoreThanHalfCount((int)allNum)) break;
                sb.append((CharSequence)this.buildMessage(finishNum, PdsCommonUtils.getMoreThanHalfCount((int)allNum)));
                break;
            }
            case "3": {
                if (finishNum >= allNum) break;
                sb.append((CharSequence)this.buildMessage(finishNum, allNum));
                break;
            }
        }
        return sb;
    }

    private StringBuilder buildMessage(int finishNum, int allNum) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u62a5\u4ef7\u4f9b\u5e94\u5546\u6570\u4e3a(%1$s), \u4e0d\u7b26\u5408\u6700\u4f4e\u8981\u6c42(%2$s)\u3002", (String)"SrcNegotiateOpenQuoteNumValidator_0", (String)"scm-src-opplugin", (Object[])new Object[0]), finishNum, allNum));
        return sb;
    }
}

