/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcPurlistPackageValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        String pentitykey = billObj.getString("pentitykey");
        if (Objects.equals(pentitykey, "src_project") || Objects.equals(pentitykey, "src_purlist")) {
            DynamicObjectCollection rows;
            String manageType = billObj.getString("managetype");
            if (Objects.equals(manageType, "2")) {
                DynamicObjectCollection rows2 = billObj.getDynamicObjectCollection("entryentity");
                if (!CollectionUtils.isEmpty((Collection)rows2)) {
                    int i = 1;
                    StringBuilder sb = new StringBuilder();
                    for (DynamicObject row : rows2) {
                        if (StringUtils.isBlank((CharSequence)row.getString("packagename"))) {
                            sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6807\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcPurlistPackageValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), i));
                            sb.append('\n');
                        }
                        ++i;
                    }
                    if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                        this.getUnSuccedResult(context, sb.toString());
                    }
                }
            } else if (Objects.equals(manageType, "1") && !CollectionUtils.isEmpty((Collection)(rows = billObj.getDynamicObjectCollection("entryentity")))) {
                StringBuilder sb = new StringBuilder();
                int emptyCount = 0;
                int noPackageNameCount = 0;
                for (DynamicObject row : rows) {
                    String packageName = row.getString("packagename");
                    if (StringUtils.isBlank((CharSequence)packageName)) {
                        ++emptyCount;
                        continue;
                    }
                    if (!"ByItem".equals(packageName)) continue;
                    ++noPackageNameCount;
                }
                if (noPackageNameCount > 0 && noPackageNameCount != rows.size()) {
                    sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u5982\u679c\u5b58\u5728\u540d\u79f0\u4e3a{0}\u7684\u6807\u6bb5\uff0c\u5219\u6240\u6709\u7684\u6807\u6bb5\u540d\u79f0\u5fc5\u987b\u4e3a\u201c{1}\u201d\u3002", (String)"SrcPurlistPackageValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), "ByItem", "ByItem"));
                } else if (emptyCount > 0 && emptyCount != rows.size()) {
                    int i = 1;
                    for (DynamicObject row : rows) {
                        if (StringUtils.isBlank((CharSequence)row.getString("packagename"))) {
                            sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6807\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcPurlistPackageValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), i));
                            sb.append('\n');
                        }
                        ++i;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    this.getUnSuccedResult(context, sb.toString());
                }
            }
        }
    }
}

