/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.extplugin.SrcValidScorerHandler;
import kd.scm.src.common.util.SrcBidAssessUtils;

public class SrcScorerTaskValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> propertys = new HashSet<String>(8);
        propertys.add("opentype");
        propertys.add("scorers");
        propertys.add("ismanualscore");
        return propertys;
    }

    public void validate(SrcValidatorData context) {
        DynamicObject scorerTaskObj;
        String scoretype;
        DynamicObject aptitudeTaskObj;
        String aptitudetype;
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        String entityName = context.getBillObj().getDataEntityType().getName();
        boolean isOfflineVerify = PdsCommonUtils.object2Boolean((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_validatorconfig", (long)context.getPluginId(), (String)"offlineScoreTaskVerify", (Object)"0", (long)projectId));
        if (!isOfflineVerify && (entityName.equals("src_aptitudeaudit") || entityName.equals("src_aptitudeaudit2") ? "2".equals(aptitudetype = (aptitudeTaskObj = QueryServiceHelper.queryOne((String)entityName, (String)"aptitudetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)})).getString("aptitudetype")) : "2".equals(scoretype = (scorerTaskObj = QueryServiceHelper.queryOne((String)"src_scorertask", (String)"scoretype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)})).getString("scoretype")))) {
            return;
        }
        QFilter scoreFilter = new QFilter("project", "=", (Object)projectId);
        String cfgEntityName = "src_bidopenconfig";
        if (entityName.equals("src_aptitudeaudit")) {
            cfgEntityName = "src_aptitudeconfigf7";
            scoreFilter.and("isaptitude", "=", (Object)"1");
        } else if (entityName.equals("src_aptitudeaudit2")) {
            cfgEntityName = "src_aptitudeconfig2f7";
            scoreFilter.and("isaptitude2", "=", (Object)"1");
        } else {
            scoreFilter.and("isaptitude", "=", (Object)"0");
            scoreFilter.and("isaptitude2", "=", (Object)"0");
        }
        scoreFilter.and("bizstatus", "!=", (Object)"E");
        QFilter cfgFilter = new QFilter("billid", "=", (Object)projectId);
        cfgFilter.and("scheme", ">", (Object)0);
        if (SrcBidAssessUtils.isParallelOpenTec((DynamicObject)context.getBillObj())) {
            cfgFilter.and("indextype.basetype", "!=", (Object)"2");
        } else if (SrcBidAssessUtils.isParallelOpenBiz((DynamicObject)context.getBillObj())) {
            cfgFilter.and("indextype.basetype", "=", (Object)"2");
        }
        if (QueryServiceHelper.exists((String)cfgEntityName, (QFilter[])cfgFilter.toArray()) && !QueryServiceHelper.exists((String)"src_scoretask", (QFilter[])scoreFilter.toArray())) {
            this.getUnSuccedResult(context, ResManager.loadKDString((String)"\u8bc4\u6807\u4efb\u52a1\u672a\u4e0b\u8fbe\uff0c\u8bf7\u5148\u4e0b\u8fbe\u5e76\u8bc4\u6807\u540e\u518d\u63d0\u4ea4\u3002", (String)"SrcScorerTaskValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = this.getQFilter(context);
        qFilter.and("scored", "=", (Object)"0");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_scoreanalyse", (String)"scorer.name", (QFilter[])qFilter.toArray());
        if (rows.size() > 0) {
            Set scorerSet = rows.stream().map(e -> e.getString("scorer.name")).collect(Collectors.toSet());
            context.setMessage(String.format(ResManager.loadKDString((String)"\u8bc4\u59d4\u201c %1$s\u201d\u6b63\u5728\u8bc4\u5206\u4e2d\uff0c\u8bf7\u7a0d\u540e\u63d0\u4ea4\u3002", (String)"SrcScorerTaskValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), String.join((CharSequence)", ", scorerSet)));
            context.setSucced(false);
            return;
        }
        ExtPluginContext extContext = new ExtPluginContext();
        extContext.setBillObj(context.getBillObj());
        ExtPluginFactory.executeExtplugin((String)SrcValidScorerHandler.class.getSimpleName(), (ExtPluginContext)extContext, (boolean)true);
    }

    private QFilter getQFilter(SrcValidatorData context) {
        String entityName = context.getBillObj().getDataEntityType().getName();
        QFilter qFilter = new QFilter("project.id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj()));
        qFilter.and("billid.bizstatus", "!=", (Object)SrmScoreStatusEnum.SCORED.getValue());
        qFilter.and("billid.bizstatus", "!=", (Object)"E");
        if ("src_aptitudeaudit".equals(entityName)) {
            qFilter.and("billid.indextype.basetype", "=", (Object)"4");
        } else if ("src_aptitudeaudit2".equals(entityName)) {
            qFilter.and("billid.indextype.basetype", "=", (Object)"7");
        } else {
            qFilter.and("billid.indextype.basetype", "!=", (Object)"4");
            qFilter.and("billid.indextype.basetype", "!=", (Object)"7");
            if (SrcBidAssessUtils.isNeedExcludeBizIndex((DynamicObject)context.getBillObj())) {
                qFilter.and("billid.indextype.basetype", "!=", (Object)"2");
            }
        }
        if (SrcBidAssessUtils.isParallelOpenTec((DynamicObject)context.getBillObj()) || "src_bidassess".equals(entityName)) {
            qFilter.and("billid.indextype.basetype", "!=", (Object)"2");
        } else if (SrcBidAssessUtils.isParallelOpenBiz((DynamicObject)context.getBillObj()) || "src_compare".equals(entityName)) {
            qFilter.and("billid.indextype.basetype", "=", (Object)"2");
        }
        return qFilter;
    }
}

