/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcSupplierUniqueValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> propertys = new HashSet<String>(8);
        propertys.add("entryentity");
        propertys.add("entryentity.supplier");
        propertys.add("entrysupplier");
        propertys.add("entrysupplier.supname");
        propertys.add("entrysupplier.package");
        return propertys;
    }

    public void validate(SrcValidatorData validatorData) {
        String entityName = validatorData.getBillObj().getDataEntityType().getName();
        String manageType = "1";
        manageType = entityName.equals("src_apply") || entityName.equals("src_demand") ? validatorData.getBillObj().getString("srctype2.managetype") : validatorData.getBillObj().getString("projectf7.managetype");
        StringBuilder sb = new StringBuilder();
        if ("src_itemsupplier".equals(entityName)) {
            DynamicObjectCollection supplierRows = validatorData.getBillObj().getDynamicObjectCollection("entryentity");
            if (supplierRows.size() == 0) {
                return;
            }
            for (DynamicObject row : supplierRows) {
                DynamicObjectCollection rows = row.getDynamicObjectCollection("supplier");
                long count = null == rows ? 0L : (long)rows.size();
                if (count <= 1L) continue;
                sb.append(String.format(ResManager.loadKDString((String)"\u5bfb\u6e90\u65b9\u5f0f\u4e3a\u5355\u4e00\u6765\u6e90\u65f6\uff0c\u6807\u7684(%1$s)\u4ec5\u5141\u8bb8\u9009\u62e91\u5bb6\u4f9b\u5e94\u5546\u3002\u5f53\u524d\u4f9b\u5e94\u5546\u6570\u4e3a(%2$s)\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"SrcSupplierUniqueValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), row.getString("purlist.materialnane"), count));
                sb.append("\n");
            }
        } else {
            DynamicObjectCollection supplierRows = validatorData.getBillObj().getDynamicObjectCollection("entrysupplier");
            if (supplierRows.size() == 0) {
                return;
            }
            Map<String, List<DynamicObject>> supplierMap = null;
            supplierMap = "2".equals(manageType) ? supplierRows.stream().filter(e -> !StringUtils.isBlank((CharSequence)e.getString("supname"))).collect(Collectors.groupingBy(e -> e.getString("package.packagename"))) : supplierRows.stream().filter(e -> !StringUtils.isBlank((CharSequence)e.getString("supname"))).collect(Collectors.groupingBy(e -> String.valueOf(e.getLong("package.id"))));
            for (Map.Entry<String, List<DynamicObject>> entry : supplierMap.entrySet()) {
                long count = entry.getValue().size();
                if (count <= 1L) continue;
                if ("2".equals(manageType)) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u5bfb\u6e90\u65b9\u5f0f\u4e3a\u5355\u4e00\u6765\u6e90\u65f6\uff0c\u6807\u6bb5(%1$s)\u4ec5\u5141\u8bb8\u9009\u62e91\u5bb6\u4f9b\u5e94\u5546\u3002\u5f53\u524d\u4f9b\u5e94\u5546\u6570\u4e3a(%2$s)\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"SrcSupplierUniqueValidator_4", (String)"scm-src-opplugin", (Object[])new Object[0]), entry.getKey(), count));
                } else {
                    sb.append(String.format(ResManager.loadKDString((String)"\u5bfb\u6e90\u65b9\u5f0f\u4e3a\u5355\u4e00\u6765\u6e90\u65f6\uff0c\u4ec5\u5141\u8bb8\u9009\u62e91\u5bb6\u4f9b\u5e94\u5546\u3002\u5f53\u524d\u4f9b\u5e94\u5546\u6570\u4e3a(%1$s)\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"SrcSupplierUniqueValidator_5", (String)"scm-src-opplugin", (Object[])new Object[0]), count));
                }
                sb.append("\n");
            }
        }
        if (sb.length() > 0) {
            validatorData.setMessage(sb.toString());
            validatorData.setSucced(false);
        }
    }
}

