/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcAptitudeUtils;

public class SrcTenderSupplierQtyValidator2
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        String operateKey = context.getOperation();
        if (Objects.isNull(operateKey)) {
            return;
        }
        if ("aptopen".equals(operateKey) && SrcAptitudeUtils.isSupplierReplyAptitude((DynamicObject)context.getBillObj())) {
            return;
        }
        StringBuilder errMessage = new StringBuilder();
        block7 : switch (operateKey) {
            case "allopen": 
            case "tecopen": 
            case "bizopen": 
            case "aptopen": 
            case "submit": {
                String manageType;
                long projectId = PdsCommonUtils.object2Long((Object)context.getBillObj().getPkValue());
                if ("src_supplier_select2".equals(context.getBillObj().getDataEntityType().getName())) {
                    projectId = PdsCommonUtils.object2Long((Object)context.getBillObj().getString("parentid"));
                    String entityName = context.getBillObj().getString("pentitykey");
                    context.setBillObj(BusinessDataServiceHelper.loadSingle((Object)projectId, (String)entityName));
                }
                DynamicObject[] openSuppliers = null;
                openSuppliers = this.isEnrollSupplier(context.getBillObj()) ? this.queryEnrollSupplier(projectId) : this.queryOpenSupplier(projectId);
                if (openSuppliers.length == 0) {
                    context.setMessage(ResManager.loadKDString((String)"\u6700\u4f4e\u9080\u8bf7\u4f9b\u5e94\u5546\u6570\u91cf\u6821\u9a8c\uff1a\u6682\u65e0\u4f9b\u5e94\u5546\u6295\u6807\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"SrcTenderSupplierQtyValidator2_4", (String)"scm-src-opplugin", (Object[])new Object[0]));
                    context.setSucced(false);
                    return;
                }
                String sourcetype = context.getBillObj().getString("sourcetype.number");
                if (SourceTypeEnums.CONFIRM_PRICE.getValue().equals(sourcetype)) {
                    return;
                }
                DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_projectf7", (String)"biderqty,isbypackage,isbypackage_apt", (QFilter[])new QFilter[]{new QFilter("fid", "=", (Object)projectId)});
                int biderQty = Optional.ofNullable(projectObj).map(obj -> obj.getInt("biderqty")).orElse(0);
                if (biderQty <= 0) {
                    return;
                }
                switch (manageType = context.getBillObj().getString("managetype")) {
                    case "1": 
                    case "3": {
                        if (this.isExistPackage(openSuppliers)) {
                            this.byPackage(openSuppliers, biderQty, errMessage, null);
                            break block7;
                        }
                        this.byProjectAndNoExistPackage(openSuppliers, biderQty, errMessage);
                        break block7;
                    }
                    case "2": {
                        boolean isByPackage = projectObj.getBoolean("isbypackage");
                        if (context.getBillObj().getDataEntityType().getName().equals("src_aptitudeaudit")) {
                            isByPackage = projectObj.getBoolean("isbypackage_apt");
                        }
                        if (isByPackage) {
                            Set packageIds = SrcBidOpenFacade.getSelectPackageIds((long)projectId, (String)context.getBizObject());
                            this.byPackage(openSuppliers, biderQty, errMessage, packageIds);
                            break block7;
                        }
                        this.byPackage(openSuppliers, biderQty, errMessage, null);
                        break block7;
                    }
                }
                break;
            }
        }
        if (errMessage.length() > 0) {
            context.setMessage(errMessage.toString());
            context.setSucced(false);
        }
    }

    private void byPackage(DynamicObject[] openSuppliers, int biderQty, StringBuilder errMessage, Set<Long> packageIds) {
        HashSet<Long> packageSet = new HashSet<Long>(16);
        Map<Long, List<DynamicObject>> groupMap = CollectionUtils.isEmpty(packageIds) ? Arrays.stream(openSuppliers).collect(Collectors.groupingBy(row -> row.getLong("package.id"))) : Arrays.stream(openSuppliers).filter(row -> packageIds.contains(row.getLong("package.id"))).collect(Collectors.groupingBy(row -> row.getLong("package.id")));
        groupMap.forEach((key, value) -> {
            long count = value.stream().filter(row -> Objects.equals(row.getBoolean("istender"), true)).filter(row -> Objects.equals(row.getBoolean("isdiscard"), false)).count();
            if (count > 0L) {
                if (count < (long)biderQty) {
                    packageSet.add((Long)key);
                }
            } else {
                long discard = value.stream().filter(row -> Objects.equals(row.getBoolean("istender"), true)).filter(row -> Objects.equals(row.getBoolean("isdiscard"), true)).count();
                if (discard == 0L) {
                    packageSet.add((Long)key);
                }
            }
        });
        if (!CollectionUtils.isEmpty(packageSet)) {
            this.buildMessage(packageSet, openSuppliers, errMessage);
        }
    }

    private void buildMessage(Set<Long> packageSet, DynamicObject[] rows, StringBuilder errMessage) {
        String message = Arrays.stream(rows).filter(row -> packageSet.contains(row.getLong("package.id"))).map(row -> row.getString("package.packagename")).distinct().collect(Collectors.joining(","));
        if (!StringUtils.isEmpty((Object)message)) {
            errMessage.append(String.format(ResManager.loadKDString((String)"%1$s\u6807\u6bb5\u6709\u6548\u6295\u6807\u4f9b\u5e94\u5546\u6570\u91cf\u5c11\u4e8e\u4e2d\u6807\u539f\u5219\u7684\u6700\u4f4e\u9080\u8bf7\u4f9b\u5e94\u5546\u6570\u91cf\uff0c \u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"SrcTenderSupplierQtyValidator2_5", (String)"scm-src-opplugin", (Object[])new Object[0]), message));
        }
    }

    private void byProjectAndNoExistPackage(DynamicObject[] openSuppliers, int biderQty, StringBuilder errMessage) {
        Map<String, List<DynamicObject>> groupMap = Arrays.stream(openSuppliers).filter(row -> Objects.equals(row.getBoolean("istender"), true)).filter(row -> Objects.equals(row.getBoolean("isdiscard"), false)).collect(Collectors.groupingBy(row -> row.getString("supplier")));
        int tenderQty = groupMap.size();
        if (tenderQty < biderQty) {
            errMessage.append(String.format(ResManager.loadKDString((String)"\u6709\u6548\u6295\u6807\u4f9b\u5e94\u5546\u6570\u91cf(%1$s)\u5c11\u4e8e\u4e2d\u6807\u539f\u5219\u7684\u6700\u4f4e\u9080\u8bf7\u4f9b\u5e94\u5546\u6570\u91cf(%2$s)\uff0c \u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"SrcTenderSupplierQtyValidator2_7", (String)"scm-src-opplugin", (Object[])new Object[0]), tenderQty, biderQty));
        }
    }

    private boolean isExistPackage(DynamicObject[] openSuppliers) {
        return Arrays.stream(openSuppliers).anyMatch(row -> {
            DynamicObject packageObj = row.getDynamicObject("package");
            if (Objects.isNull(packageObj)) {
                return false;
            }
            return !Objects.equals(packageObj.getString("packagename"), "ByItem");
        });
    }

    private DynamicObject[] queryOpenSupplier(long projectId) {
        QFilter qFilters = SupplierUtil.getValidTenderSupplierFilter((long)projectId, (long)0L);
        String selectProperties = "suppliertype,supplier,billid,package,istender,isdiscard";
        return BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectProperties, (QFilter[])qFilters.toArray());
    }

    private DynamicObject[] queryEnrollSupplier(long projectId) {
        QFilter qFilters = new QFilter("billid", "=", (Object)projectId);
        String selectProperties = "suppliertype,supplier,billid,package,istender,isdiscard";
        return BusinessDataServiceHelper.load((String)"src_enrollsupplier", (String)selectProperties, (QFilter[])qFilters.toArray());
    }

    private boolean isEnrollSupplier(DynamicObject billObj) {
        String suppliertype;
        return ("src_aptitudeaudit".equals(billObj.getDataEntityType().getName()) || "src_aptitudeaudit2".equals(billObj.getDataEntityType().getName())) && "1".equals(suppliertype = billObj.getString("suppliertype"));
    }
}

