/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcTenderSupplierQtyValidator3
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        String operateKey = context.getOperation();
        if (Objects.isNull(operateKey)) {
            return;
        }
        String sourcetype = context.getBillObj().getString("sourcetype.number");
        if (SourceTypeEnums.CONFIRM_PRICE.getValue().equals(sourcetype)) {
            return;
        }
        StringBuilder errMessage = new StringBuilder();
        switch (operateKey) {
            case "allopen": 
            case "tecopen": 
            case "bizopen": 
            case "aptopen": 
            case "submit": {
                DynamicObject[] rows = this.queryOpenSupplier(PdsCommonUtils.object2Long((Object)context.getBillObj().getPkValue()));
                if (null == rows || rows.length == 0) {
                    return;
                }
                for (DynamicObject row : rows) {
                    if (this.isValid(row)) continue;
                    this.buildMessage(context.getBillObj().getString("managetype"), row, errMessage);
                }
                break;
            }
        }
        if (errMessage.length() > 0) {
            context.setMessage(errMessage.toString());
            context.setSucced(false);
        }
    }

    private void buildMessage(String manageType, DynamicObject row, StringBuilder errMessage) {
        if ("2".equals(manageType)) {
            errMessage.append(ResManager.loadKDString((String)"\u6807\u6bb5\uff1a", (String)"SrcTenderSupplierQtyValidator3_0", (String)"scm-src-opplugin", (Object[])new Object[0])).append(row.getString("package.packagename")).append("\uff0c");
        }
        errMessage.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\uff1a", (String)"SrcTenderSupplierQtyValidator3_1", (String)"scm-src-opplugin", (Object[])new Object[0])).append(row.getString("supplier.name"));
        errMessage.append(ResManager.loadKDString((String)" \u672a\u6295\u6807", (String)"SrcTenderSupplierQtyValidator3_2", (String)"scm-src-opplugin", (Object[])new Object[0])).append("\n");
    }

    private DynamicObject[] queryOpenSupplier(long projectId) {
        QFilter qFilters = new QFilter("billid", "=", (Object)projectId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopensupplier", (boolean)false);
        return BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFields, (QFilter[])qFilters.toArray());
    }

    public boolean isValid(DynamicObject row) {
        if (row.getBoolean("istender")) {
            return true;
        }
        if (row.getBoolean("isabandon")) {
            return true;
        }
        if (row.getBoolean("isdiscard")) {
            return true;
        }
        return "2".equals(row.getString("isaptitude"));
    }
}

