/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.vie.PdsVieHelper;

public class SrcVieAgainRegionValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        String viePattern = null;
        String taxType = null;
        try {
            viePattern = billObj.getString("project.viepattern");
            taxType = billObj.getString("project.taxtype");
        }
        catch (Exception e) {
            viePattern = "1";
            taxType = "2";
        }
        Map viePatternTitleMap = PdsVieHelper.getViePatternTitle((String)viePattern, (String)taxType);
        int i = 1;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : rows) {
            if (row.getBigDecimal("viefrom").compareTo(BigDecimal.ZERO) > 0 && row.getBigDecimal("vieto").compareTo(BigDecimal.ZERO) > 0 && row.getBigDecimal("viefrom").compareTo(row.getBigDecimal("vieto")) >= 0) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c, {1}\u5fc5\u987b\u5c0f\u4e8e{2}\u3002", (String)"SrcVieAgainRegionValidator_1", (String)"scm-src-opplugin", (Object[])new Object[0]), i, viePatternTitleMap.get("viefrom"), viePatternTitleMap.get("vieto")));
            }
            ++i;
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            this.getUnSuccedResult(context, sb.toString());
        }
    }
}

